/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.MessageReceiverListenerImpl;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.task.BlockingTask;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SmppConsumer.class);
    private static final String RECONNECT_TASK_NAME = "smpp-consumer-reconnect";
    private final SmppConfiguration configuration;
    private final MessageReceiverListener messageReceiverListener;
    private final SessionStateListener internalSessionStateListener;
    private final ReentrantLock reconnectLock = new ReentrantLock();
    private final ScheduledExecutorService reconnectService;
    private SMPPSession session;

    public SmppConsumer(SmppEndpoint endpoint, SmppConfiguration config, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.reconnectService = SmppUtils.createExecutor((BaseService)this, (Endpoint)endpoint, RECONNECT_TASK_NAME);
        this.configuration = config;
        this.internalSessionStateListener = (newState, oldState, source) -> {
            if (this.configuration.getSessionStateListener() != null) {
                this.configuration.getSessionStateListener().onStateChange(newState, oldState, source);
            }
            if (newState.equals((Object)SessionState.UNBOUND) || newState.equals((Object)SessionState.CLOSED)) {
                LOG.warn(newState.equals((Object)SessionState.UNBOUND) ? "Session to {} was unbound - trying to reconnect" : "Lost connection to: {} - trying to reconnect...", (Object)this.getEndpoint().getConnectionString());
                this.closeSession();
                this.reconnect();
            }
        };
        this.messageReceiverListener = new MessageReceiverListenerImpl(this, this.getEndpoint(), this.getProcessor(), this.getExceptionHandler());
    }

    protected void doStart() throws Exception {
        LOG.debug("Connecting to: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStart();
        this.session = this.createSession();
        LOG.info("Connected to: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private SMPPSession createSession() throws IOException {
        SMPPSession newSession = this.createSMPPSession();
        newSession.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        newSession.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        newSession.setPduProcessorDegree(this.configuration.getPduProcessorDegree().intValue());
        newSession.setQueueCapacity(this.configuration.getPduProcessorQueueCapacity().intValue());
        newSession.addSessionStateListener(this.internalSessionStateListener);
        newSession.setMessageReceiverListener(this.messageReceiverListener);
        newSession.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_RX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, this.configuration.getAddressRange(), this.configuration.getInterfaceVersionByte()));
        return newSession;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppConnectionFactory.getInstance(this.configuration));
    }

    protected void doStop() throws Exception {
        SmppUtils.shutdownReconnectService(this.reconnectService);
        LOG.debug("Disconnecting from: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStop();
        this.closeSession();
        LOG.info("Disconnected from: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.internalSessionStateListener);
            this.session.unbindAndClose();
            this.session = null;
        }
    }

    private boolean doReconnect() {
        try {
            LOG.info("Trying to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            if (SmppUtils.isServiceStopping((BaseService)this)) {
                return true;
            }
            if (SmppUtils.isSessionClosed(this.session)) {
                return this.tryCreateSession();
            }
            LOG.info("Nothing to do: the session is not closed");
        }
        catch (Exception e) {
            LOG.error("Unable to reconnect to {}: {}", new Object[]{this.getEndpoint().getConnectionString(), e.getMessage(), e});
            return false;
        }
        return true;
    }

    private boolean tryCreateSession() {
        try {
            LOG.info("Creating a new session to {}", (Object)this.getEndpoint().getConnectionString());
            this.session = this.createSession();
            LOG.info("Reconnected to {}", (Object)this.getEndpoint().getConnectionString());
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            this.closeSession();
            return false;
        }
    }

    private void reconnect() {
        if (this.reconnectLock.tryLock()) {
            BlockingTask task = SmppUtils.newReconnectTask(this.reconnectService, RECONNECT_TASK_NAME, this.configuration.getInitialReconnectDelay(), this.configuration.getReconnectDelay(), this.configuration.getMaxReconnect());
            try {
                task.run(this::doReconnect);
            }
            finally {
                this.reconnectLock.unlock();
            }
        } else {
            LOG.warn("Thread {} could not acquire a lock for creating the session during consumer reconnection", (Object)Thread.currentThread().getId());
        }
    }

    public String toString() {
        return "SmppConsumer[" + this.getEndpoint().getConnectionString() + "]";
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }
}

