/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.spi.Metadata;

public interface SmppConstants {
    @Metadata(label="producer", description="*For SubmitSm, SubmitMulti and ReplaceSm*  The data\ncoding according to the SMPP 3.4 specification, section 5.2.19. Use the\nURI option `alphabet` settings above.", javaType="Byte")
    public static final String ALPHABET = "CamelSmppAlphabet";
    @Metadata(description="The command", javaType="String")
    public static final String COMMAND = "CamelSmppCommand";
    @Metadata(label="consumer", description="*only for AlertNotification, DeliverSm and DataSm* The command id field\nidentifies the particular SMPP PDU. For the complete list of defined\nvalues see chapter 5.1.2.1 in the smpp specification v3.4.", javaType="Integer")
    public static final String COMMAND_ID = "CamelSmppCommandId";
    @Metadata(label="consumer", description="*only for DataSm* The Command status of the message.", javaType="Integer")
    public static final String COMMAND_STATUS = "CamelSmppCommandStatus";
    @Metadata(label="producer", description="*For SubmitSm, SubmitMulti and ReplaceSm*  The data\ncoding according to the SMPP 3.4 specification, section 5.2.19. Use the\nURI option `alphabet` settings above.", javaType="Byte")
    public static final String DATA_CODING = "CamelSmppDataCoding";
    @Metadata(label="producer", description="The splitter", javaType="org.apache.camel.component.smpp.SmppSplitter")
    public static final String DATA_SPLITTER = "CamelSmppSplitter";
    @Metadata(label="consumer", description="*only for smsc DeliveryReceipt* Number of short messages delivered. This\nis only relevant where the original message was submitted to a\ndistribution list.The value is padded with leading zeros if necessary.", javaType="Integer")
    public static final String DELIVERED = "CamelSmppDelivered";
    @Metadata(description="*Producer:* *only for SubmitSm, SubmitMulti, CancelSm and DataSm* Defines the\ndestination SME address(es). For mobile terminated messages, this is the\ndirectory number of the recipient MS. It must be a `List<String>` for\nSubmitMulti and a `String` otherwise.\n*Consumer:* *only for DeliverSm and DataSm:* Defines the destination SME address.\nFor mobile terminated messages, this is the directory number of the\nrecipient MS.", javaType="List or String")
    public static final String DEST_ADDR = "CamelSmppDestAddr";
    @Metadata(description="*Producer:* *only for SubmitSm, SubmitMulti, CancelSm and DataSm* Defines the\nnumeric plan indicator (NPI) to be used in the SME destination address\nparameters. Use the URI option `sourceAddrNpi` values defined above.\n*Consumer:* *only for DataSm* Defines the numeric plan indicator (NPI) in the\ndestination address parameters. Use the URI option `sourceAddrNpi`\nvalues defined above.", javaType="Byte")
    public static final String DEST_ADDR_NPI = "CamelSmppDestAddrNpi";
    @Metadata(description="*Producer:* *only for SubmitSm, SubmitMulti, CancelSm and DataSm* Defines the type\nof number (TON) to be used in the SME destination address parameters.\nUse the `sourceAddrTon` URI option values defined above.\n*Consumer:* *only for DataSm* Defines the type of number (TON) in the destination\naddress parameters. Use the `sourceAddrTon` URI option values defined\nabove.", javaType="Byte")
    public static final String DEST_ADDR_TON = "CamelSmppDestAddrTon";
    @Metadata(label="consumer", description="*only for smsc DeliveryReceipt* The time and date at which the short\nmessage reached it's final state. The format is as follows: YYMMDDhhmm.", javaType="Date")
    public static final String DONE_DATE = "CamelSmppDoneDate";
    @Metadata(label="producer", description="*only for SubmitSm,\nSubmitMulti and DataSm*.  Specifies the encoding (character set name) of\nthe bytes in the message body.  If the message body is a string then\nthis is not relevant because Java Strings are always Unicode.  If the\nbody is a byte array then this header can be used to indicate that it is\nISO-8859-1 or some other value.  Default value is specified by the\nendpoint configuration parameter _encoding_", javaType="String")
    public static final String ENCODING = "CamelSmppEncoding";
    @Metadata(description="*Producer:* *only for SubmitMultiSm* The errors which\noccurred by sending the short message(s) the form `Map<String, List<Map<String, Object>>>` (messageID : (destAddr :\naddress, error : errorCode)).\n*Consumer:* *only for smsc DeliveryReceipt* Where appropriate this may hold a\nNetwork specific error code or an SMSC error code for the attempted\ndelivery of the message. These errors are Network or SMSC specific and\nare not included here.", javaType="String or Map<String, List<Map<String, Object>>>")
    public static final String ERROR = "CamelSmppError";
    @Metadata(label="producer", description="the ASM class", javaType="org.jsmpp.bean.ESMClass")
    public static final String ESM_CLASS = "CamelSmppClass";
    @Metadata(label="consumer", description="*only for AlertNotification* Defines the destination ESME address. For\nmobile terminated messages, this is the directory number of the\nrecipient MS.", javaType="String")
    public static final String ESME_ADDR = "CamelSmppEsmeAddr";
    @Metadata(label="consumer", description="*only for AlertNotification* Defines the numeric plan indicator (NPI) to\nbe used in the ESME originator address parameters. Use the URI option\n`sourceAddrNpi` values defined above.", javaType="Byte")
    public static final String ESME_ADDR_NPI = "CamelSmppEsmeAddrNpi";
    @Metadata(label="consumer", description="*only for AlertNotification* Defines the type of number (TON) to be used\nin the ESME originator address parameters. Use the `sourceAddrTon` URI\noption values defined above.", javaType="Byte")
    public static final String ESME_ADDR_TON = "CamelSmppEsmeAddrTon";
    @Metadata(label="producer", description="The final date", javaType="java.util.Date")
    public static final String FINAL_DATE = "CamelSmppFinalDate";
    @Metadata(label="consumer", description="*only for smsc DeliveryReceipt:* The final status of the message.", javaType="org.jsmpp.util.DeliveryReceiptState")
    public static final String FINAL_STATUS = "CamelSmppStatus";
    @Metadata(description="*Producer:* The id to identify the submitted short message(s) for later use.\nIn case of a ReplaceSm, QuerySm, CancelSm and DataSm this\nheader value is a `String`. In case of a SubmitSm or SubmitMultiSm this\nheader value is a `List<String>`.\n*Consumer:* *only for smsc DeliveryReceipt and DataSm* The message ID allocated to\nthe message by the SMSC when originally submitted.", javaType="String or List<String>")
    public static final String ID = "CamelSmppId";
    @Metadata(label="producer", description="The message date", javaType="String")
    public static final String MESSAGE_STATE = "CamelSmppMessageState";
    @Metadata(label="consumer", description="Identifies the type of an incoming message:\n`AlertNotification`: an SMSC alert notification,\n`DataSm`: an SMSC data short message,\n`DeliveryReceipt`: an SMSC delivery receipt,\n`DeliverSm`: an SMSC deliver short message", javaType="String")
    public static final String MESSAGE_TYPE = "CamelSmppMessageType";
    @Metadata(label="producer", description="*only for SubmitSm and SubmitMulti* Allows the originating SME to assign\na priority level to the short message. Use the URI option `priorityFlag`\nsettings above.", javaType="Byte")
    public static final String PRIORITY_FLAG = "CamelSmppPriorityFlag";
    @Metadata(label="producer", description="The protocol id", javaType="Byte")
    public static final String PROTOCOL_ID = "CamelSmppProtocolId";
    @Metadata(description="*Producer:* *only for SubmitSm, ReplaceSm, SubmitMulti and DataSm* Is used to\nrequest an SMSC delivery receipt and/or SME originated acknowledgements.\nUse the URI option `registeredDelivery` settings above.\n*Consumer:* *only for DataSm* Is used to request an delivery receipt and/or SME\noriginated acknowledgements. Same values as in Producer header list\nabove.", javaType="Byte")
    public static final String REGISTERED_DELIVERY = "CamelSmppRegisteredDelivery";
    @Metadata(label="producer", description="*only for SubmitSm, SubmitMulti* Is used to\nrequest the SMSC delivery receipt only on the last segment of multi-segment (long) messages.\nUse the URI option `singleDLR` settings above.", javaType="Boolean")
    public static final String SINGLE_DLR = "CamelSmppSingleDLR";
    @Metadata(label="producer", description="*only for SubmitSm and SubmitMulti* The replace if present flag\nparameter is used to request the SMSC to replace a previously submitted\nmessage, that is still pending delivery. The SMSC will replace an\nexisting message provided that the source address, destination address\nand service type match the same fields in the new message. The following\nvalues are defined: `0`, Don't replace and `1`, Replace", javaType="Boolean")
    public static final String REPLACE_IF_PRESENT_FLAG = "CamelSmppReplaceIfPresentFlag";
    @Metadata(description="*Producer:* only for SubmitSm, SubmitMulti and ReplaceSm* This parameter specifies\nthe scheduled time at which the message delivery should be first\nattempted. It defines either the absolute date and time or relative time\nfrom the current SMSC time at which delivery of this message will be\nattempted by the SMSC. It can be specified in either absolute time\nformat or relative time format. The encoding of a time format is\nspecified in chapter 7.1.1. in the smpp specification v3.4.\n*Consumer:* *only for DeliverSm:* This parameter specifies the scheduled time at\nwhich the message delivery should be first attempted. It defines either\nthe absolute date and time or relative time from the current SMSC time\nat which delivery of this message will be attempted by the SMSC. It can\nbe specified in either absolute time format or relative time format. The\nencoding of a time format is specified in Section 7.1.1. in the smpp\nspecification v3.4.", javaType="Date")
    public static final String SCHEDULE_DELIVERY_TIME = "CamelSmppScheduleDeliveryTime";
    @Metadata(label="producer", description="*only for SubmitSm and SubmitMultiSm* The total\nnumber of messages which has been sent.", javaType="Integer")
    public static final String SENT_MESSAGE_COUNT = "CamelSmppSentMessageCount";
    @Metadata(label="consumer", description="*only for AlertNotification, DeliverSm and DataSm* A sequence number\nallows a response PDU to be correlated with a request PDU. The\nassociated SMPP response PDU must preserve this field.", javaType="int")
    public static final String SEQUENCE_NUMBER = "CamelSmppSequenceNumber";
    @Metadata(description="*Producer:* The service type parameter can be used to indicate the SMS Application\nservice associated with the message. Use the URI option `serviceType`\nsettings above.\n*Consumer:* *only for DeliverSm and DataSm* The service type parameter indicates the\nSMS Application service associated with the message.", javaType="String")
    public static final String SERVICE_TYPE = "CamelSmppServiceType";
    @Metadata(description="*Producer:* Defines the address of SME (Short Message Entity) which originated this message.\n*Consumer:* *Only for AlertNotification, DeliverSm and DataSm* Defines the address\nof SME (Short Message Entity) which originated this message.", javaType="String")
    public static final String SOURCE_ADDR = "CamelSmppSourceAddr";
    @Metadata(description="*Producer:* Defines the numeric plan indicator (NPI) to be used in the SME\noriginator address parameters. Use the URI option `sourceAddrNpi` values\ndefined above.\n*Consumer:* *only for AlertNotification and DataSm* Defines the numeric plan\nindicator (NPI) to be used in the SME originator address parameters. Use\nthe URI option `sourceAddrNpi` values defined above.", javaType="Byte")
    public static final String SOURCE_ADDR_NPI = "CamelSmppSourceAddrNpi";
    @Metadata(description="*Producer:* Defines the type of number (TON) to be used in the SME originator\naddress parameters. Use the `sourceAddrTon` URI option values defined\nabove.\n*Consumer:* *only for AlertNotification and DataSm* Defines the type of number (TON)\nto be used in the SME originator address parameters. Use the\n`sourceAddrTon` URI option values defined above.", javaType="Byte")
    public static final String SOURCE_ADDR_TON = "CamelSmppSourceAddrTon";
    @Metadata(label="consumer", description="*only for smsc DeliveryReceipt* Number of short messages originally\nsubmitted. This is only relevant when the original message was submitted\nto a distribution list.The value is padded with leading zeros if\nnecessary.", javaType="Integer")
    public static final String SUBMITTED = "CamelSmppSubmitted";
    @Metadata(label="consumer", description="*only for smsc DeliveryReceipt* The time and date at which the short\nmessage was submitted. In the case of a message which has been replaced,\nthis is the date that the original message was replaced. The format is\nas follows: YYMMDDhhmm.", javaType="Date")
    public static final String SUBMIT_DATE = "CamelSmppSubmitDate";
    @Metadata(label="producer", description="The system id.", javaType="String")
    public static final String SYSTEM_ID = "CamelSmppSystemId";
    @Metadata(label="producer", description="The password.", javaType="String")
    public static final String PASSWORD = "CamelSmppPassword";
    @Metadata(description="*Producer:* *only for SubmitSm, SubmitMulti and ReplaceSm* The validity period\nparameter indicates the SMSC expiration time, after which the message\nshould be discarded if not delivered to the destination. If it's\nprovided as `Date`, it's interpreted as absolute time or relative time\nformat if you provide it as `String` as specified in chapter 7.1.1 in\nthe smpp specification v3.4.\n*Consumer:* *only for DeliverSm* The validity period parameter indicates the SMSC\nexpiration time, after which the message should be discarded if not\ndelivered to the destination. It can be defined in absolute time format\nor relative time format. The encoding of absolute and relative time\nformat is specified in Section 7.1.1 in the smpp specification v3.4.", javaType="String or Date")
    public static final String VALIDITY_PERIOD = "CamelSmppValidityPeriod";
    @Metadata(label="consumer", description="The optional parameters by name.", javaType="Map<String, Object>", deprecationNote="Use CamelSmppOptionalParameter instead")
    public static final String OPTIONAL_PARAMETERS = "CamelSmppOptionalParameters";
    @Metadata(description="*Producer:* *only for SubmitSm, SubmitMulti and\nDataSm* The optional parameter which are send to the SMSC. The value is\nconverted in the following way: `String` -> `org.jsmpp.bean.OptionalParameter.COctetString`, \n`byte[]` -> `org.jsmpp.bean.OptionalParameter.OctetString`, \n`Byte` -> `org.jsmpp.bean.OptionalParameter.Byte`,\n`Integer` -> `org.jsmpp.bean.OptionalParameter.Int`,\n`Short` -> `org.jsmpp.bean.OptionalParameter.Short`, \n`null` -> `org.jsmpp.bean.OptionalParameter.Null`\n*Consumer:* *only for DeliverSm* The optional\nparameters send back by the SMSC. The key is the `Short` code for the\noptional parameter. The value is converted in the following way: \n`org.jsmpp.bean.OptionalParameter.COctetString` -> `String`,\n`org.jsmpp.bean.OptionalParameter.OctetString` -> `byte[]`,\n`org.jsmpp.bean.OptionalParameter.Byte` -> `Byte`,\n`org.jsmpp.bean.OptionalParameter.Int` -> `Integer`,\n`org.jsmpp.bean.OptionalParameter.Short` -> `Short`,\n`org.jsmpp.bean.OptionalParameter.Null` -> `null`", javaType="Map<Short, Object>")
    public static final String OPTIONAL_PARAMETER = "CamelSmppOptionalParameter";
    @Metadata(label="producer", description="*only for SubmitSm,\nSubmitMulti and DataSm*.  Specifies the policy for message splitting for\nthis exchange.  Possible values are described in the endpoint\nconfiguration parameter _splittingPolicy_", javaType="String")
    public static final String SPLITTING_POLICY = "CamelSmppSplittingPolicy";
    public static final byte UNKNOWN_ALPHABET = -1;
}

