/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.smpp.SmppSplittingPolicy;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SessionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SmppConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(SmppConfiguration.class);
    @UriPath(defaultValue="localhost")
    private String host = "localhost";
    @UriPath(defaultValue="2775")
    private Integer port = 2775;
    @UriParam(label="security", defaultValue="smppclient", secret=true)
    private String systemId = "smppclient";
    @UriParam(label="security", secret=true)
    private String password = "password";
    @UriParam(label="common", defaultValue="")
    private String systemType = "";
    @UriParam(label="codec")
    private byte dataCoding = 0;
    @UriParam(label="codec", enums="0,4,8")
    private byte alphabet = Alphabet.ALPHA_DEFAULT.value();
    @UriParam(label="codec", defaultValue="ISO-8859-1")
    private String encoding = "ISO-8859-1";
    @UriParam(label="advanced", defaultValue="5000")
    private Integer enquireLinkTimer = 5000;
    @UriParam(label="advanced", defaultValue="10000")
    private Integer transactionTimer = 10000;
    @UriParam(label="producer", enums="0,1,2")
    private byte registeredDelivery = SMSCDeliveryReceipt.SUCCESS_FAILURE.value();
    @UriParam(label="producer", defaultValue="", enums="CMT,CPT,VMN,VMA,WAP,USSD")
    private String serviceType = "";
    @UriParam(label="producer", defaultValue="1616")
    private String sourceAddr = "1616";
    @UriParam(label="producer", defaultValue="1717")
    private String destAddr = "1717";
    @UriParam(label="producer", enums="0,1,2,3,4,5,6")
    private byte sourceAddrTon = TypeOfNumber.UNKNOWN.value();
    @UriParam(label="producer", enums="0,1,2,3,4,5,6")
    private byte destAddrTon = TypeOfNumber.UNKNOWN.value();
    @UriParam(label="producer", enums="0,1,2,3,6,8,9,10,13,18")
    private byte sourceAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam(label="producer", enums="0,1,2,3,6,8,9,10,13,18")
    private byte destAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam(label="consumer")
    private String addressRange = "";
    @UriParam(label="producer")
    private byte protocolId = 0;
    @UriParam(label="producer", enums="0,1,2,3")
    private byte priorityFlag = 1;
    @UriParam(label="producer", enums="0,1")
    private byte replaceIfPresentFlag = ReplaceIfPresentFlag.DEFAULT.value();
    @UriParam(label="producer", enums="0,1,2,3,4,5,6")
    private byte typeOfNumber = TypeOfNumber.UNKNOWN.value();
    @UriParam(label="producer", enums="0,1,2,3,6,8,9,10,13,18")
    private byte numberingPlanIndicator = NumberingPlanIndicator.UNKNOWN.value();
    @UriParam(label="security")
    private boolean usingSSL;
    @UriParam(label="common", defaultValue="5000")
    private long initialReconnectDelay = 5000L;
    @UriParam(label="common", defaultValue="5000")
    private long reconnectDelay = 5000L;
    @UriParam(label="common", defaultValue="2147483647")
    private int maxReconnect = Integer.MAX_VALUE;
    @UriParam(label="producer")
    private boolean lazySessionCreation;
    @UriParam(label="proxy")
    private String httpProxyHost;
    @UriParam(label="proxy", defaultValue="3128")
    private Integer httpProxyPort = 3128;
    @UriParam(label="proxy")
    private String httpProxyUsername;
    @UriParam(label="proxy")
    private String httpProxyPassword;
    @UriParam(label="proxy")
    private Map<String, String> proxyHeaders;
    @UriParam(label="advanced")
    private SessionStateListener sessionStateListener;
    @UriParam(defaultValue="ALLOW")
    private SmppSplittingPolicy splittingPolicy = SmppSplittingPolicy.ALLOW;

    public void configureFromURI(URI uri) {
        this.setSystemId(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getScheme().startsWith("smpps")) {
            this.setUsingSSL(true);
        }
    }

    public SmppConfiguration copy() {
        try {
            return (SmppConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte dataCoding) {
        this.dataCoding = dataCoding;
    }

    public byte getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(byte alphabet) {
        this.alphabet = alphabet;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            LOG.warn("Unsupported encoding \"{}\" is being set.", (Object)encoding);
        }
        this.encoding = encoding;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    public void setEnquireLinkTimer(Integer enquireLinkTimer) {
        this.enquireLinkTimer = enquireLinkTimer;
    }

    public Integer getTransactionTimer() {
        return this.transactionTimer;
    }

    public void setTransactionTimer(Integer transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public byte getSourceAddrTon() {
        return this.sourceAddrTon;
    }

    public void setSourceAddrTon(byte sourceAddrTon) {
        this.sourceAddrTon = sourceAddrTon;
    }

    public byte getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(byte destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public byte getSourceAddrNpi() {
        return this.sourceAddrNpi;
    }

    public void setSourceAddrNpi(byte sourceAddrNpi) {
        this.sourceAddrNpi = sourceAddrNpi;
    }

    public byte getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(byte destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(byte protocolId) {
        this.protocolId = protocolId;
    }

    public byte getPriorityFlag() {
        return this.priorityFlag;
    }

    public void setPriorityFlag(byte priorityFlag) {
        this.priorityFlag = priorityFlag;
    }

    public byte getReplaceIfPresentFlag() {
        return this.replaceIfPresentFlag;
    }

    public void setReplaceIfPresentFlag(byte replaceIfPresentFlag) {
        this.replaceIfPresentFlag = replaceIfPresentFlag;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public String getDestAddr() {
        return this.destAddr;
    }

    public void setDestAddr(String destAddr) {
        this.destAddr = destAddr;
    }

    public byte getTypeOfNumber() {
        return this.typeOfNumber;
    }

    public void setTypeOfNumber(byte typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
    }

    public byte getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(byte numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public boolean getUsingSSL() {
        return this.usingSSL;
    }

    public void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public void setMaxReconnect(int maxReconnect) {
        this.maxReconnect = maxReconnect;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public SessionStateListener getSessionStateListener() {
        return this.sessionStateListener;
    }

    public void setSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public SmppSplittingPolicy getSplittingPolicy() {
        return this.splittingPolicy;
    }

    public void setSplittingPolicy(SmppSplittingPolicy splittingPolicy) {
        this.splittingPolicy = splittingPolicy;
    }

    public void setProxyHeaders(Map<String, String> proxyHeaders) {
        this.proxyHeaders = proxyHeaders;
    }

    public Map<String, String> getProxyHeaders() {
        return this.proxyHeaders;
    }

    public String toString() {
        return "SmppConfiguration[usingSSL=" + this.usingSSL + ", enquireLinkTimer=" + this.enquireLinkTimer + ", host=" + this.host + ", password=" + this.password + ", port=" + this.port + ", systemId=" + this.systemId + ", systemType=" + this.systemType + ", dataCoding=" + this.dataCoding + ", alphabet=" + this.alphabet + ", encoding=" + this.encoding + ", transactionTimer=" + this.transactionTimer + ", registeredDelivery=" + this.registeredDelivery + ", serviceType=" + this.serviceType + ", sourceAddrTon=" + this.sourceAddrTon + ", destAddrTon=" + this.destAddrTon + ", sourceAddrNpi=" + this.sourceAddrNpi + ", destAddrNpi=" + this.destAddrNpi + ", addressRange=" + this.addressRange + ", protocolId=" + this.protocolId + ", priorityFlag=" + this.priorityFlag + ", replaceIfPresentFlag=" + this.replaceIfPresentFlag + ", sourceAddr=" + this.sourceAddr + ", destAddr=" + this.destAddr + ", typeOfNumber=" + this.typeOfNumber + ", numberingPlanIndicator=" + this.numberingPlanIndicator + ", initialReconnectDelay=" + this.initialReconnectDelay + ", reconnectDelay=" + this.reconnectDelay + ", maxReconnect=" + this.maxReconnect + ", lazySessionCreation=" + this.lazySessionCreation + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + ", splittingPolicy=" + (Object)((Object)this.splittingPolicy) + ", proxyHeaders=" + this.proxyHeaders + "]";
    }
}

