/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.nio.charset.Charset;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSmCommand;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SMPPSession;

public class SmppReplaceSmCommand
extends SmppSmCommand {
    public SmppReplaceSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        String body = (String)exchange.getIn().getBody(String.class);
        byte providedAlphabet = this.getProvidedAlphabet(exchange);
        Alphabet determinedAlphabet = this.determineAlphabet(exchange);
        Charset charset = this.determineCharset(providedAlphabet, determinedAlphabet.value());
        byte[] message = null;
        if (body != null) {
            message = body.getBytes(charset);
        }
        ReplaceSm replaceSm = this.createReplaceSmTempate(exchange);
        replaceSm.setShortMessage(message);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending replacement command for a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)replaceSm.getMessageId());
        }
        try {
            this.session.replaceShortMessage(replaceSm.getMessageId(), TypeOfNumber.valueOf((byte)replaceSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)replaceSm.getSourceAddrNpi()), replaceSm.getSourceAddr(), replaceSm.getScheduleDeliveryTime(), replaceSm.getValidityPeriod(), new RegisteredDelivery(replaceSm.getRegisteredDelivery()), replaceSm.getSmDefaultMsgId(), replaceSm.getShortMessage());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent replacement command for a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)replaceSm.getMessageId());
        }
        Message rspMsg = this.getResponseMessage(exchange);
        rspMsg.setHeader("CamelSmppId", (Object)replaceSm.getMessageId());
    }

    protected ReplaceSm createReplaceSmTempate(Exchange exchange) {
        Message in = exchange.getIn();
        ReplaceSm replaceSm = new ReplaceSm();
        if (in.getHeaders().containsKey("CamelSmppId")) {
            replaceSm.setMessageId((String)in.getHeader("CamelSmppId", String.class));
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            replaceSm.setSourceAddr((String)in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            replaceSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            replaceSm.setSourceAddrTon(((Byte)in.getHeader("CamelSmppSourceAddrTon", Byte.class)).byteValue());
        } else {
            replaceSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            replaceSm.setSourceAddrNpi(((Byte)in.getHeader("CamelSmppSourceAddrNpi", Byte.class)).byteValue());
        } else {
            replaceSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            replaceSm.setRegisteredDelivery(((Byte)in.getHeader("CamelSmppRegisteredDelivery", Byte.class)).byteValue());
        } else {
            replaceSm.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        if (in.getHeaders().containsKey("CamelSmppScheduleDeliveryTime")) {
            replaceSm.setScheduleDeliveryTime(SmppUtils.formatTime((Date)in.getHeader("CamelSmppScheduleDeliveryTime", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppValidityPeriod")) {
            Object validityPeriod = in.getHeader("CamelSmppValidityPeriod");
            if (validityPeriod instanceof String) {
                replaceSm.setValidityPeriod((String)validityPeriod);
            } else if (validityPeriod instanceof Date) {
                replaceSm.setValidityPeriod(SmppUtils.formatTime((Date)validityPeriod));
            }
        }
        return replaceSm;
    }
}

