/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.MessageReceiverListenerImpl;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SmppConsumer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;
    private MessageReceiverListener messageReceiverListener;
    private SessionStateListener sessionStateListener;
    private final ReentrantLock reconnectLock = new ReentrantLock();

    public SmppConsumer(SmppEndpoint endpoint, SmppConfiguration config, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = config;
        this.sessionStateListener = new SessionStateListener(){

            public void onStateChange(SessionState newState, SessionState oldState, Object source) {
                if (newState.equals((Object)SessionState.CLOSED)) {
                    LOG.warn("Lost connection to: " + SmppConsumer.this.getEndpoint().getConnectionString() + " - trying to reconnect...");
                    SmppConsumer.this.closeSession();
                    SmppConsumer.this.reconnect(SmppConsumer.this.configuration.getInitialReconnectDelay());
                }
            }
        };
        this.messageReceiverListener = new MessageReceiverListenerImpl(this.getEndpoint(), this.getProcessor(), this.getExceptionHandler());
    }

    protected void doStart() throws Exception {
        LOG.debug("Connecting to: " + this.getEndpoint().getConnectionString() + "...");
        super.doStart();
        this.session = this.createSession();
        LOG.info("Connected to: " + this.getEndpoint().getConnectionString());
    }

    private SMPPSession createSession() throws IOException {
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.addSessionStateListener(this.sessionStateListener);
        session.setMessageReceiverListener(this.messageReceiverListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_RX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, ""));
        return session;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppConnectionFactory.getInstance(this.configuration));
    }

    protected void doStop() throws Exception {
        LOG.debug("Disconnecting from: " + this.getEndpoint().getConnectionString() + "...");
        super.doStop();
        this.closeSession();
        LOG.info("Disconnected from: " + this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.sessionStateListener);
            try {
                Thread.sleep(1000L);
                this.session.unbindAndClose();
            }
            catch (Exception e) {
                LOG.warn("Could not close session " + this.session);
            }
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(final long initialReconnectDelay) {
        if (this.reconnectLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        boolean reconnected = false;
                        LOG.info("Schedule reconnect after " + initialReconnectDelay + " millis");
                        try {
                            Thread.sleep(initialReconnectDelay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        int attempt = 0;
                        while (!(SmppConsumer.this.isStopping() || SmppConsumer.this.isStopped() || SmppConsumer.this.session != null && !SmppConsumer.this.session.getSessionState().equals((Object)SessionState.CLOSED))) {
                            try {
                                LOG.info("Trying to reconnect to " + SmppConsumer.this.getEndpoint().getConnectionString() + " - attempt #" + ++attempt + "...");
                                SmppConsumer.this.session = SmppConsumer.this.createSession();
                                reconnected = true;
                            }
                            catch (IOException e) {
                                LOG.info("Failed to reconnect to " + SmppConsumer.this.getEndpoint().getConnectionString());
                                SmppConsumer.this.closeSession();
                                try {
                                    Thread.sleep(SmppConsumer.this.configuration.getReconnectDelay());
                                }
                                catch (InterruptedException ee) {}
                            }
                        }
                        if (reconnected) {
                            LOG.info("Reconnected to " + SmppConsumer.this.getEndpoint().getConnectionString());
                        }
                    }
                };
                Thread t = new Thread(r);
                t.start();
                t.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.reconnectLock.unlock();
            }
        }
    }

    public String toString() {
        return "SmppConsumer[" + this.getEndpoint().getConnectionString() + "]";
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }
}

