/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmppCommand
implements SmppCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SMPPSession session;
    protected SmppConfiguration config;

    public AbstractSmppCommand(SMPPSession session, SmppConfiguration config) {
        this.session = session;
        this.config = config;
    }

    protected Message getResponseMessage(Exchange exchange) {
        Message message;
        if (exchange.getPattern().isOutCapable()) {
            this.log.debug("Exchange is out capable, setting headers on out exchange...");
            message = exchange.getOut();
        } else {
            this.log.debug("Exchange is not out capable, setting headers on in exchange...");
            message = exchange.getIn();
        }
        return message;
    }
}

