/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSmCommand;
import org.apache.camel.component.smpp.SmppSplitter;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.session.SMPPSession;

public class SmppSubmitMultiCommand
extends SmppSmCommand {
    public SmppSubmitMultiCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        SubmitMulti[] submitMulties = this.createSubmitMulti(exchange);
        ArrayList<SubmitMultiResult> results = new ArrayList<SubmitMultiResult>(submitMulties.length);
        for (int i = 0; i < submitMulties.length; ++i) {
            SubmitMulti submitMulti = submitMulties[i];
            this.log.debug("Sending multiple short messages for exchange id '{}'...", (Object)exchange.getExchangeId());
            try {
                SubmitMultiResult result = this.session.submitMultiple(submitMulti.getServiceType(), TypeOfNumber.valueOf((byte)submitMulti.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)submitMulti.getSourceAddrNpi()), submitMulti.getSourceAddr(), (Address[])submitMulti.getDestAddresses(), new ESMClass(submitMulti.getEsmClass()), submitMulti.getProtocolId(), submitMulti.getPriorityFlag(), submitMulti.getScheduleDeliveryTime(), submitMulti.getValidityPeriod(), new RegisteredDelivery(submitMulti.getRegisteredDelivery()), new ReplaceIfPresentFlag(submitMulti.getReplaceIfPresentFlag()), (DataCoding)new GeneralDataCoding(submitMulti.getDataCoding()), submitMulti.getSmDefaultMsgId(), submitMulti.getShortMessage(), new OptionalParameter[0]);
                results.add(result);
                continue;
            }
            catch (Exception e) {
                throw new SmppException(e);
            }
        }
        this.log.debug("Sent multiple short messages for exchange id '{}' and received results '{}'", (Object)exchange.getExchangeId(), results);
        ArrayList<String> messageIDs = new ArrayList<String>(results.size());
        HashMap errors = new HashMap();
        for (SubmitMultiResult result : results) {
            UnsuccessDelivery[] deliveries = result.getUnsuccessDeliveries();
            if (deliveries != null) {
                ArrayList undelivered = new ArrayList();
                for (UnsuccessDelivery delivery : deliveries) {
                    HashMap<String, Object> error = new HashMap<String, Object>();
                    error.put("CamelSmppDestAddr", delivery.getDestinationAddress().getAddress());
                    error.put("CamelSmppError", delivery.getErrorStatusCode());
                    undelivered.add(error);
                }
                if (!undelivered.isEmpty()) {
                    errors.put(result.getMessageId(), undelivered);
                }
            }
            messageIDs.add(result.getMessageId());
        }
        Message message = this.getResponseMessage(exchange);
        message.setHeader("CamelSmppId", messageIDs);
        message.setHeader("CamelSmppSentMessageCount", (Object)messageIDs.size());
        if (!errors.isEmpty()) {
            message.setHeader("CamelSmppError", errors);
        }
    }

    protected SubmitMulti[] createSubmitMulti(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        byte providedAlphabet = this.getProvidedAlphabet(exchange);
        Alphabet determinedAlphabet = this.determineAlphabet(exchange);
        SmppSplitter splitter = this.createSplitter(exchange);
        Charset charset = this.determineCharset(providedAlphabet, determinedAlphabet.value());
        byte[][] segments = splitter.split(body.getBytes(charset));
        GeneralDataCoding dataCoding = new GeneralDataCoding(false, true, MessageClass.CLASS1, determinedAlphabet);
        ESMClass esmClass = segments.length > 1 ? new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.UDHI) : new ESMClass();
        SubmitMulti template = this.createSubmitMultiTemplate(exchange);
        SubmitMulti[] submitMulties = new SubmitMulti[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            SubmitMulti submitMulti = SmppUtils.copySubmitMulti(template);
            submitMulti.setEsmClass(esmClass.value());
            submitMulti.setDataCoding(dataCoding.value());
            submitMulti.setShortMessage(segments[i]);
            submitMulties[i] = submitMulti;
        }
        return submitMulties;
    }

    protected SubmitMulti createSubmitMultiTemplate(Exchange exchange) {
        Message in = exchange.getIn();
        SubmitMulti submitMulti = new SubmitMulti();
        byte destAddrTon = in.getHeaders().containsKey("CamelSmppDestAddrTon") ? ((Byte)in.getHeader("CamelSmppDestAddrTon", Byte.class)).byteValue() : this.config.getDestAddrTon();
        byte destAddrNpi = in.getHeaders().containsKey("CamelSmppDestAddrNpi") ? ((Byte)in.getHeader("CamelSmppDestAddrNpi", Byte.class)).byteValue() : this.config.getDestAddrNpi();
        List<String> destAddresses = in.getHeaders().containsKey("CamelSmppDestAddr") ? (List<String>)in.getHeader("CamelSmppDestAddr", List.class) : Arrays.asList(this.config.getDestAddr());
        Address[] addresses = new Address[destAddresses.size()];
        int addrNum = 0;
        for (String destAddr : destAddresses) {
            Address addr = new Address(destAddrTon, destAddrNpi, destAddr);
            addresses[addrNum++] = addr;
        }
        submitMulti.setDestAddresses((DestinationAddress[])addresses);
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            submitMulti.setSourceAddr((String)in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            submitMulti.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            submitMulti.setSourceAddrTon(((Byte)in.getHeader("CamelSmppSourceAddrTon", Byte.class)).byteValue());
        } else {
            submitMulti.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            submitMulti.setSourceAddrNpi(((Byte)in.getHeader("CamelSmppSourceAddrNpi", Byte.class)).byteValue());
        } else {
            submitMulti.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            submitMulti.setServiceType((String)in.getHeader("CamelSmppServiceType", String.class));
        } else {
            submitMulti.setServiceType(this.config.getServiceType());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            submitMulti.setRegisteredDelivery(((Byte)in.getHeader("CamelSmppRegisteredDelivery", Byte.class)).byteValue());
        } else {
            submitMulti.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        if (in.getHeaders().containsKey("CamelSmppProtocolId")) {
            submitMulti.setProtocolId(((Byte)in.getHeader("CamelSmppProtocolId", Byte.class)).byteValue());
        } else {
            submitMulti.setProtocolId(this.config.getProtocolId());
        }
        if (in.getHeaders().containsKey("CamelSmppPriorityFlag")) {
            submitMulti.setPriorityFlag(((Byte)in.getHeader("CamelSmppPriorityFlag", Byte.class)).byteValue());
        } else {
            submitMulti.setPriorityFlag(this.config.getPriorityFlag());
        }
        if (in.getHeaders().containsKey("CamelSmppScheduleDeliveryTime")) {
            submitMulti.setScheduleDeliveryTime(SmppUtils.formatTime((Date)in.getHeader("CamelSmppScheduleDeliveryTime", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppValidityPeriod")) {
            submitMulti.setValidityPeriod(SmppUtils.formatTime((Date)in.getHeader("CamelSmppValidityPeriod", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppReplaceIfPresentFlag")) {
            submitMulti.setReplaceIfPresentFlag(((Byte)in.getHeader("CamelSmppReplaceIfPresentFlag", Byte.class)).byteValue());
        } else {
            submitMulti.setReplaceIfPresentFlag(this.config.getReplaceIfPresentFlag());
        }
        return submitMulti;
    }
}

