/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.component.smpp.SmppSSLConnectionFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.PDUComposer;
import org.jsmpp.util.RandomMessageIDGenerator;

public class SmppConsumer
extends DefaultConsumer {
    private static final transient Log LOG = LogFactory.getLog(SmppConsumer.class);
    private SmppConfiguration configuration;
    private SMPPSession session;
    private MessageReceiverListener messageReceiverListener;
    private SessionStateListener sessionStateListener;

    public SmppConsumer(SmppEndpoint endpoint, SmppConfiguration config, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = config;
        this.sessionStateListener = new SessionStateListener(){

            public void onStateChange(SessionState newState, SessionState oldState, Object source) {
                if (newState.equals((Object)SessionState.CLOSED)) {
                    LOG.warn((Object)("Loost connection to: " + SmppConsumer.this.getEndpoint().getConnectionString() + " - trying to reconnect..."));
                    SmppConsumer.this.closeSession(SmppConsumer.this.session);
                    SmppConsumer.this.reconnect(SmppConsumer.this.configuration.getInitialReconnectDelay());
                }
            }
        };
        this.messageReceiverListener = new MessageReceiverListener(){
            private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received an alertNotification " + alertNotification));
                }
                try {
                    Exchange exchange = SmppConsumer.this.getEndpoint().createOnAcceptAlertNotificationExchange(alertNotification);
                    LOG.trace((Object)"Processing the new smpp exchange...");
                    SmppConsumer.this.getProcessor().process(exchange);
                    LOG.trace((Object)"Processed the new smpp exchange");
                }
                catch (Exception e) {
                    SmppConsumer.this.getExceptionHandler().handleException((Throwable)e);
                }
            }

            public void onAcceptDeliverSm(DeliverSm deliverSm) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received a deliverSm " + deliverSm));
                }
                try {
                    Exchange exchange = SmppConsumer.this.getEndpoint().createOnAcceptDeliverSmExchange(deliverSm);
                    LOG.trace((Object)"processing the new smpp exchange...");
                    SmppConsumer.this.getProcessor().process(exchange);
                    LOG.trace((Object)"processed the new smpp exchange");
                }
                catch (Exception e) {
                    SmppConsumer.this.getExceptionHandler().handleException((Throwable)e);
                }
            }

            public DataSmResult onAcceptDataSm(DataSm dataSm, Session session) throws ProcessRequestException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received a dataSm " + dataSm));
                }
                MessageId newMessageId = this.messageIDGenerator.newMessageId();
                try {
                    Exchange exchange = SmppConsumer.this.getEndpoint().createOnAcceptDataSm(dataSm, newMessageId.getValue());
                    LOG.trace((Object)"processing the new smpp exchange...");
                    SmppConsumer.this.getProcessor().process(exchange);
                    LOG.trace((Object)"processed the new smpp exchange");
                }
                catch (Exception e) {
                    SmppConsumer.this.getExceptionHandler().handleException((Throwable)e);
                    throw new ProcessRequestException(e.getMessage(), 255, (Throwable)e);
                }
                return new DataSmResult(newMessageId, dataSm.getOptionalParametes());
            }
        };
    }

    protected void doStart() throws Exception {
        LOG.debug((Object)("Connecting to: " + this.getEndpoint().getConnectionString() + "..."));
        super.doStart();
        this.session = this.createSession();
        LOG.info((Object)("Connected to: " + this.getEndpoint().getConnectionString()));
    }

    private SMPPSession createSession() throws IOException {
        SMPPSession session = this.createSMPPSession();
        session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.addSessionStateListener(this.sessionStateListener);
        session.setMessageReceiverListener(this.messageReceiverListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_RX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, ""));
        return session;
    }

    SMPPSession createSMPPSession() {
        if (this.configuration.getUsingSSL()) {
            return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppSSLConnectionFactory.getInstance());
        }
        return new SMPPSession();
    }

    protected void doStop() throws Exception {
        LOG.debug((Object)("Disconnecting from: " + this.getEndpoint().getConnectionString() + "..."));
        super.doStop();
        this.closeSession(this.session);
        LOG.info((Object)("Disconnected from: " + this.getEndpoint().getConnectionString()));
    }

    private void closeSession(SMPPSession session) {
        if (session != null) {
            session.removeSessionStateListener(this.sessionStateListener);
            session.close();
            session = null;
        }
    }

    private void reconnect(final long initialReconnectDelay) {
        new Thread(){

            public void run() {
                LOG.info((Object)("Schedule reconnect after " + initialReconnectDelay + " millis"));
                try {
                    Thread.sleep(initialReconnectDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                int attempt = 0;
                while (!(SmppConsumer.this.isStopping() || SmppConsumer.this.isStopped() || SmppConsumer.this.session != null && !SmppConsumer.this.session.getSessionState().equals((Object)SessionState.CLOSED))) {
                    try {
                        LOG.info((Object)("Trying to reconnect to " + SmppConsumer.this.getEndpoint().getConnectionString() + " - attempt #" + ++attempt + "..."));
                        SmppConsumer.this.session = SmppConsumer.this.createSession();
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Failed to reconnect to " + SmppConsumer.this.getEndpoint().getConnectionString()));
                        SmppConsumer.this.closeSession(SmppConsumer.this.session);
                        try {
                            Thread.sleep(SmppConsumer.this.configuration.getReconnectDelay());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                LOG.info((Object)("Reconnected to " + SmppConsumer.this.getEndpoint().getConnectionString()));
            }
        }.start();
    }

    public String toString() {
        return "SmppConsumer[" + this.getEndpoint().getConnectionString() + "]";
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }
}

