/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.smpp.SmppBinding;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConsumer;
import org.apache.camel.component.smpp.SmppProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;

@UriEndpoint(scheme="smpp", syntax="smpp:host:port", consumerClass=SmppConsumer.class, label="mobile,messaging")
public class SmppEndpoint
extends DefaultEndpoint {
    private SmppBinding binding;
    @UriParam
    private SmppConfiguration configuration;

    public SmppEndpoint(String endpointUri, Component component, SmppConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    protected String createEndpointUri() {
        return this.getConnectionString();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SmppConsumer answer = new SmppConsumer(this, this.configuration, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new SmppProducer(this, this.configuration);
    }

    public Exchange createOnAcceptAlertNotificationExchange(AlertNotification alertNotification) {
        return this.createOnAcceptAlertNotificationExchange(this.getExchangePattern(), alertNotification);
    }

    public Exchange createOnAcceptAlertNotificationExchange(ExchangePattern exchangePattern, AlertNotification alertNotification) {
        Exchange exchange = this.createExchange(exchangePattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)this.getBinding().createSmppMessage(alertNotification));
        return exchange;
    }

    public Exchange createOnAcceptDeliverSmExchange(DeliverSm deliverSm) throws Exception {
        return this.createOnAcceptDeliverSmExchange(this.getExchangePattern(), deliverSm);
    }

    public Exchange createOnAcceptDeliverSmExchange(ExchangePattern exchangePattern, DeliverSm deliverSm) throws Exception {
        Exchange exchange = this.createExchange(exchangePattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)this.getBinding().createSmppMessage(deliverSm));
        return exchange;
    }

    public Exchange createOnAcceptDataSm(DataSm dataSm, String smppMessageId) {
        return this.createOnAcceptDataSm(this.getExchangePattern(), dataSm, smppMessageId);
    }

    public Exchange createOnAcceptDataSm(ExchangePattern exchangePattern, DataSm dataSm, String smppMessageId) {
        Exchange exchange = this.createExchange(exchangePattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)this.getBinding().createSmppMessage(dataSm, smppMessageId));
        return exchange;
    }

    public String getConnectionString() {
        return (this.configuration.getUsingSSL() ? "smpps://" : "smpp://") + (this.getConfiguration().getSystemId() != null ? this.getConfiguration().getSystemId() + "@" : "") + this.getConfiguration().getHost() + ":" + this.getConfiguration().getPort();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public SmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new SmppBinding(this.getConfiguration());
        }
        return this.binding;
    }

    public void setBinding(SmppBinding binding) {
        this.binding = binding;
    }
}

