/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.nio.charset.Charset;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.Smpp8BitSplitter;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppDefaultSplitter;
import org.apache.camel.component.smpp.SmppSplitter;
import org.apache.camel.component.smpp.SmppUcs2Splitter;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.session.SMPPSession;

public abstract class SmppSmCommand
extends AbstractSmppCommand {
    protected Charset ascii = Charset.forName("US-ASCII");
    protected Charset latin1 = Charset.forName("ISO-8859-1");
    protected Charset charset;

    public SmppSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
        this.charset = Charset.forName(config.getEncoding());
    }

    protected SmppSplitter createSplitter(Message message) {
        SmppSplitter splitter;
        Alphabet alphabet = this.determineAlphabet(message);
        String body = (String)message.getBody(String.class);
        switch (alphabet) {
            case ALPHA_8_BIT: {
                splitter = new Smpp8BitSplitter(body.length());
                break;
            }
            case ALPHA_UCS2: {
                splitter = new SmppUcs2Splitter(body.length());
                break;
            }
            default: {
                splitter = new SmppDefaultSplitter(body.length());
            }
        }
        return splitter;
    }

    protected final byte[] getShortMessage(Message message) {
        if (SmppSmCommand.has8bitDataCoding(message)) {
            return (byte[])message.getBody(byte[].class);
        }
        byte providedAlphabet = this.getProvidedAlphabet(message);
        Alphabet determinedAlphabet = this.determineAlphabet(message);
        Charset charset = this.determineCharset(providedAlphabet, determinedAlphabet.value());
        String body = (String)message.getBody(String.class);
        return body.getBytes(charset);
    }

    private static boolean has8bitDataCoding(Message message) {
        Byte dcs = (Byte)message.getHeader("CamelSmppDataCoding", Byte.class);
        if (dcs != null) {
            return SmppUtils.parseAlphabetFromDataCoding(dcs) == Alphabet.ALPHA_8_BIT;
        }
        Byte alphabet = (Byte)message.getHeader("CamelSmppAlphabet", Byte.class);
        return alphabet != null && alphabet.equals(Alphabet.ALPHA_8_BIT.value());
    }

    private byte getProvidedAlphabet(Message message) {
        byte alphabet = this.config.getAlphabet();
        if (message.getHeaders().containsKey("CamelSmppAlphabet")) {
            alphabet = (Byte)message.getHeader("CamelSmppAlphabet", Byte.class);
        }
        return alphabet;
    }

    private Charset determineCharset(byte providedAlphabet, byte determinedAlphabet) {
        if (providedAlphabet == Alphabet.ALPHA_UCS2.value() || providedAlphabet == -1 && determinedAlphabet == Alphabet.ALPHA_UCS2.value()) {
            return Charset.forName("UTF-16BE");
        }
        return this.charset;
    }

    private Alphabet determineAlphabet(Message message) {
        Alphabet alphabetObj;
        String body = (String)message.getBody(String.class);
        byte alphabet = this.getProvidedAlphabet(message);
        if (alphabet == -1) {
            byte[] messageBytes;
            alphabetObj = Alphabet.ALPHA_UCS2;
            if (this.isLatin1Compatible(this.charset) && SmppUtils.isGsm0338Encodeable(messageBytes = body.getBytes(this.charset))) {
                alphabetObj = Alphabet.ALPHA_DEFAULT;
            }
        } else {
            alphabetObj = Alphabet.valueOf((byte)alphabet);
        }
        return alphabetObj;
    }

    private boolean isLatin1Compatible(Charset c) {
        return c.equals(this.ascii) || c.equals(this.latin1);
    }
}

