/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class SmppComponent
extends DefaultComponent {
    private SmppConfiguration configuration;

    public SmppComponent() {
    }

    public SmppComponent(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        if (this.configuration == null) {
            this.configuration = new SmppConfiguration();
        }
        SmppConfiguration config = this.configuration.copy();
        config.configureFromURI(new URI(uri));
        if (parameters.containsKey("systemType") && parameters.get("systemType") == null) {
            config.setSystemType("");
            parameters.remove("systemType");
        }
        if (parameters.containsKey("serviceType") && parameters.get("serviceType") == null) {
            config.setServiceType("");
            parameters.remove("serviceType");
        }
        this.setProperties(config, parameters);
        return this.createEndpoint(uri, config);
    }

    protected Endpoint createEndpoint(SmppConfiguration config) throws Exception {
        return this.createEndpoint(null, config);
    }

    protected Endpoint createEndpoint(String uri, SmppConfiguration config) throws Exception {
        return new SmppEndpoint(uri, (Component)this, config);
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmppConfiguration configuration) {
        this.configuration = configuration;
    }
}

