/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URI;
import org.apache.camel.RuntimeCamelException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SessionStateListener;

public class SmppConfiguration
implements Cloneable {
    private String host = "localhost";
    private Integer port = 2775;
    private String systemId = "smppclient";
    private String password = "password";
    private String systemType = "cp";
    private byte dataCoding = 0;
    private byte alphabet = Alphabet.ALPHA_DEFAULT.value();
    private String encoding = "ISO-8859-1";
    private Integer enquireLinkTimer = 5000;
    private Integer transactionTimer = 10000;
    private byte registeredDelivery = SMSCDeliveryReceipt.SUCCESS_FAILURE.value();
    private String serviceType = "CMT";
    private String sourceAddr = "1616";
    private String destAddr = "1717";
    private byte sourceAddrTon = TypeOfNumber.UNKNOWN.value();
    private byte destAddrTon = TypeOfNumber.UNKNOWN.value();
    private byte sourceAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    private byte destAddrNpi = NumberingPlanIndicator.UNKNOWN.value();
    private String addressRange = "";
    private byte protocolId = 0;
    private byte priorityFlag = 1;
    private byte replaceIfPresentFlag = ReplaceIfPresentFlag.DEFAULT.value();
    private byte typeOfNumber = TypeOfNumber.UNKNOWN.value();
    private byte numberingPlanIndicator = NumberingPlanIndicator.UNKNOWN.value();
    private boolean usingSSL;
    private long initialReconnectDelay = 5000L;
    private long reconnectDelay = 5000L;
    private boolean lazySessionCreation;
    private String httpProxyHost;
    private Integer httpProxyPort = 3128;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private SessionStateListener sessionStateListener;

    public void configureFromURI(URI uri) {
        this.setSystemId(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getScheme().startsWith("smpps")) {
            this.setUsingSSL(true);
        }
    }

    public SmppConfiguration copy() {
        try {
            return (SmppConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte dataCoding) {
        this.alphabet = dataCoding;
    }

    public byte getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(byte alphabet) {
        this.alphabet = alphabet;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    public void setEnquireLinkTimer(Integer enquireLinkTimer) {
        this.enquireLinkTimer = enquireLinkTimer;
    }

    public Integer getTransactionTimer() {
        return this.transactionTimer;
    }

    public void setTransactionTimer(Integer transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public byte getSourceAddrTon() {
        return this.sourceAddrTon;
    }

    public void setSourceAddrTon(byte sourceAddrTon) {
        this.sourceAddrTon = sourceAddrTon;
    }

    public byte getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(byte destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public byte getSourceAddrNpi() {
        return this.sourceAddrNpi;
    }

    public void setSourceAddrNpi(byte sourceAddrNpi) {
        this.sourceAddrNpi = sourceAddrNpi;
    }

    public byte getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(byte destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(byte protocolId) {
        this.protocolId = protocolId;
    }

    public byte getPriorityFlag() {
        return this.priorityFlag;
    }

    public void setPriorityFlag(byte priorityFlag) {
        this.priorityFlag = priorityFlag;
    }

    public byte getReplaceIfPresentFlag() {
        return this.replaceIfPresentFlag;
    }

    public void setReplaceIfPresentFlag(byte replaceIfPresentFlag) {
        this.replaceIfPresentFlag = replaceIfPresentFlag;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public String getDestAddr() {
        return this.destAddr;
    }

    public void setDestAddr(String destAddr) {
        this.destAddr = destAddr;
    }

    public byte getTypeOfNumber() {
        return this.typeOfNumber;
    }

    public void setTypeOfNumber(byte typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
    }

    public byte getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(byte numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public boolean getUsingSSL() {
        return this.usingSSL;
    }

    public void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public SessionStateListener getSessionStateListener() {
        return this.sessionStateListener;
    }

    public void setSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public String toString() {
        return "SmppConfiguration[usingSSL=" + this.usingSSL + ", enquireLinkTimer=" + this.enquireLinkTimer + ", host=" + this.host + ", password=" + this.password + ", port=" + this.port + ", systemId=" + this.systemId + ", systemType=" + this.systemType + ", dataCoding=" + this.dataCoding + ", alphabet=" + this.alphabet + ", encoding=" + this.encoding + ", transactionTimer=" + this.transactionTimer + ", registeredDelivery=" + this.registeredDelivery + ", serviceType=" + this.serviceType + ", sourceAddrTon=" + this.sourceAddrTon + ", destAddrTon=" + this.destAddrTon + ", sourceAddrNpi=" + this.sourceAddrNpi + ", destAddrNpi=" + this.destAddrNpi + ", addressRange=" + this.addressRange + ", protocolId=" + this.protocolId + ", priorityFlag=" + this.priorityFlag + ", replaceIfPresentFlag=" + this.replaceIfPresentFlag + ", sourceAddr=" + this.sourceAddr + ", destAddr=" + this.destAddr + ", typeOfNumber=" + this.typeOfNumber + ", numberingPlanIndicator=" + this.numberingPlanIndicator + ", initialReconnectDelay=" + this.initialReconnectDelay + ", reconnectDelay=" + this.reconnectDelay + ", lazySessionCreation=" + this.lazySessionCreation + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + "]";
    }
}

