/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.SMPPSession;

public class SmppDataSmCommand
extends AbstractSmppCommand {
    public SmppDataSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        DataSmResult result;
        DataSm dataSm = this.createDataSm(exchange);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending a data short message for exchange id '{}'...", (Object)exchange.getExchangeId());
        }
        try {
            result = this.session.dataShortMessage(dataSm.getServiceType(), TypeOfNumber.valueOf((byte)dataSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)dataSm.getSourceAddrNpi()), dataSm.getSourceAddr(), TypeOfNumber.valueOf((byte)dataSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)dataSm.getDestAddrNpi()), dataSm.getDestAddress(), new ESMClass(dataSm.getEsmClass()), new RegisteredDelivery(dataSm.getRegisteredDelivery()), DataCoding.newInstance((byte)dataSm.getDataCoding()), dataSm.getOptionalParametes());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent a data short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)result.getMessageId());
        }
        Message message = this.getResponseMessage(exchange);
        message.setHeader("CamelSmppId", (Object)result.getMessageId());
        message.setHeader("CamelSmppOptionalParameters", this.getOptionalParametersAsMap(result.getOptionalParameters()));
    }

    protected Map<String, String> getOptionalParametersAsMap(OptionalParameter[] optionalParameters) {
        if (optionalParameters == null) {
            return null;
        }
        HashMap<String, String> optParams = new HashMap<String, String>();
        for (OptionalParameter optionalParameter : optionalParameters) {
            String value = null;
            if (optionalParameter instanceof OptionalParameter.COctetString) {
                value = ((OptionalParameter.COctetString)optionalParameter).getValueAsString();
            } else if (optionalParameter instanceof OptionalParameter.OctetString) {
                value = ((OptionalParameter.OctetString)optionalParameter).getValueAsString();
            } else if (optionalParameter instanceof OptionalParameter.Int) {
                value = String.valueOf(((OptionalParameter.Int)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Short) {
                value = String.valueOf(((OptionalParameter.Short)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Byte) {
                value = String.valueOf(((OptionalParameter.Byte)optionalParameter).getValue());
            } else if (optionalParameter instanceof OptionalParameter.Null) {
                value = null;
            }
            optParams.put(OptionalParameter.Tag.valueOf((short)optionalParameter.tag).name(), value);
        }
        return optParams;
    }

    protected DataSm createDataSm(Exchange exchange) {
        Message in = exchange.getIn();
        DataSm dataSm = new DataSm();
        if (in.getHeaders().containsKey("CamelSmppDataCoding")) {
            dataSm.setDataCoding(((Byte)in.getHeader("CamelSmppDataCoding", Byte.class)).byteValue());
        } else {
            dataSm.setDataCoding(this.config.getDataCoding());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddr")) {
            dataSm.setDestAddress((String)in.getHeader("CamelSmppDestAddr", String.class));
        } else {
            dataSm.setDestAddress(this.config.getDestAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrTon")) {
            dataSm.setDestAddrTon(((Byte)in.getHeader("CamelSmppDestAddrTon", Byte.class)).byteValue());
        } else {
            dataSm.setDestAddrTon(this.config.getDestAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrNpi")) {
            dataSm.setDestAddrNpi(((Byte)in.getHeader("CamelSmppDestAddrNpi", Byte.class)).byteValue());
        } else {
            dataSm.setDestAddrNpi(this.config.getDestAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            dataSm.setSourceAddr((String)in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            dataSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            dataSm.setSourceAddrTon(((Byte)in.getHeader("CamelSmppSourceAddrTon", Byte.class)).byteValue());
        } else {
            dataSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            dataSm.setSourceAddrNpi(((Byte)in.getHeader("CamelSmppSourceAddrNpi", Byte.class)).byteValue());
        } else {
            dataSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            dataSm.setServiceType((String)in.getHeader("CamelSmppServiceType", String.class));
        } else {
            dataSm.setServiceType(this.config.getServiceType());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            dataSm.setRegisteredDelivery(((Byte)in.getHeader("CamelSmppRegisteredDelivery", Byte.class)).byteValue());
        } else {
            dataSm.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        Map optinalParamaters = (Map)in.getHeader("CamelSmppOptionalParameters", Map.class);
        if (optinalParamaters != null) {
            List<OptionalParameter> optParams = this.createOptionalParameters(optinalParamaters);
            dataSm.setOptionalParametes(optParams.toArray(new OptionalParameter[optParams.size()]));
        } else {
            dataSm.setOptionalParametes(new OptionalParameter[0]);
        }
        return dataSm;
    }
}

