/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmppCommand
implements SmppCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SMPPSession session;
    protected SmppConfiguration config;

    public AbstractSmppCommand(SMPPSession session, SmppConfiguration config) {
        this.session = session;
        this.config = config;
    }

    protected Message getResponseMessage(Exchange exchange) {
        Message message = exchange.getPattern().isOutCapable() ? exchange.getOut() : exchange.getIn();
        return message;
    }

    protected List<OptionalParameter> createOptionalParameters(Map<String, String> optinalParamaters) {
        ArrayList<OptionalParameter> optParams = new ArrayList<OptionalParameter>();
        for (Map.Entry<String, String> entry : optinalParamaters.entrySet()) {
            OptionalParameter.OctetString optParam = null;
            try {
                OptionalParameter.Tag tag = OptionalParameter.Tag.valueOf((String)entry.getKey());
                Class<? extends OptionalParameter> type = this.determineTypeClass(tag);
                if (OptionalParameter.OctetString.class.equals(type)) {
                    optParam = new OptionalParameter.OctetString(tag.code(), entry.getValue());
                } else if (OptionalParameter.COctetString.class.equals(type)) {
                    optParam = new OptionalParameter.COctetString(tag.code(), entry.getValue());
                } else if (OptionalParameter.Byte.class.equals(type)) {
                    optParam = new OptionalParameter.Byte(tag.code(), Byte.valueOf(entry.getValue()).byteValue());
                } else if (OptionalParameter.Int.class.equals(type)) {
                    optParam = new OptionalParameter.Int(tag.code(), Integer.valueOf(entry.getValue()).intValue());
                } else if (OptionalParameter.Short.class.equals(type)) {
                    optParam = new OptionalParameter.Short(tag.code(), Short.valueOf(entry.getValue()).shortValue());
                } else if (OptionalParameter.Null.class.equals(type)) {
                    optParam = new OptionalParameter.Null(tag);
                }
                optParams.add((OptionalParameter)optParam);
            }
            catch (Exception e) {
                this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return optParams;
    }

    protected Class<? extends OptionalParameter> determineTypeClass(OptionalParameter.Tag tag) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = tag.getClass().getDeclaredField("type");
        f.setAccessible(true);
        return (Class)f.get(tag);
    }
}

