/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppCommandType;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppMessage;
import org.apache.camel.component.smpp.SmppMessageType;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;

public class SmppBinding {
    private SmppConfiguration configuration;

    public SmppBinding() {
        this.configuration = new SmppConfiguration();
    }

    public SmppBinding(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppCommand createSmppCommand(SMPPSession session, Exchange exchange) {
        SmppCommandType commandType = SmppCommandType.fromExchange(exchange);
        SmppCommand command = commandType.createCommand(session, this.configuration);
        return command;
    }

    public SmppMessage createSmppMessage(AlertNotification alertNotification) {
        SmppMessage smppMessage = new SmppMessage(alertNotification, this.configuration);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.AlertNotification.toString());
        smppMessage.setHeader("CamelSmppSequenceNumber", alertNotification.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", alertNotification.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", alertNotification.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", alertNotification.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", alertNotification.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", alertNotification.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppEsmeAddr", alertNotification.getEsmeAddr());
        smppMessage.setHeader("CamelSmppEsmeAddrNpi", alertNotification.getEsmeAddrNpi());
        smppMessage.setHeader("CamelSmppEsmeAddrTon", alertNotification.getEsmeAddrTon());
        return smppMessage;
    }

    public SmppMessage createSmppMessage(DeliverSm deliverSm) throws Exception {
        SmppMessage smppMessage = new SmppMessage(deliverSm, this.configuration);
        if (deliverSm.isSmscDeliveryReceipt()) {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliveryReceipt.toString());
            DeliveryReceipt smscDeliveryReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
            smppMessage.setBody(smscDeliveryReceipt.getText());
            smppMessage.setHeader("CamelSmppId", smscDeliveryReceipt.getId());
            smppMessage.setHeader("CamelSmppDelivered", smscDeliveryReceipt.getDelivered());
            smppMessage.setHeader("CamelSmppDoneDate", smscDeliveryReceipt.getDoneDate());
            if (!"000".equals(smscDeliveryReceipt.getError())) {
                smppMessage.setHeader("CamelSmppError", smscDeliveryReceipt.getError());
            }
            smppMessage.setHeader("CamelSmppSubmitDate", smscDeliveryReceipt.getSubmitDate());
            smppMessage.setHeader("CamelSmppSubmitted", smscDeliveryReceipt.getSubmitted());
            smppMessage.setHeader("CamelSmppStatus", smscDeliveryReceipt.getFinalStatus());
        } else {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliverSm.toString());
            if (deliverSm.getShortMessage() != null) {
                smppMessage.setBody(String.valueOf(new String(deliverSm.getShortMessage(), this.configuration.getEncoding())));
            } else if (deliverSm.getOptionalParametes() != null && deliverSm.getOptionalParametes().length > 0) {
                List<OptionalParameter> oplist = Arrays.asList(deliverSm.getOptionalParametes());
                for (OptionalParameter optPara : oplist) {
                    if (OptionalParameter.Tag.MESSAGE_PAYLOAD.code() != optPara.tag || !OptionalParameter.OctetString.class.isInstance(optPara)) continue;
                    smppMessage.setBody(((OptionalParameter.OctetString)optPara).getValueAsString());
                    break;
                }
            }
            smppMessage.setHeader("CamelSmppSequenceNumber", deliverSm.getSequenceNumber());
            smppMessage.setHeader("CamelSmppCommandId", deliverSm.getCommandId());
            smppMessage.setHeader("CamelSmppSourceAddr", deliverSm.getSourceAddr());
            smppMessage.setHeader("CamelSmppDestAddr", deliverSm.getDestAddress());
            smppMessage.setHeader("CamelSmppScheduleDeliveryTime", deliverSm.getScheduleDeliveryTime());
            smppMessage.setHeader("CamelSmppValidityPeriod", deliverSm.getValidityPeriod());
            smppMessage.setHeader("CamelSmppServiceType", deliverSm.getServiceType());
        }
        return smppMessage;
    }

    public SmppMessage createSmppMessage(DataSm dataSm, String smppMessageId) {
        SmppMessage smppMessage = new SmppMessage(dataSm, this.configuration);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DataSm.toString());
        smppMessage.setHeader("CamelSmppId", smppMessageId);
        smppMessage.setHeader("CamelSmppSequenceNumber", dataSm.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", dataSm.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", dataSm.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", dataSm.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", dataSm.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", dataSm.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppDestAddr", dataSm.getDestAddress());
        smppMessage.setHeader("CamelSmppDestAddrNpi", dataSm.getDestAddrNpi());
        smppMessage.setHeader("CamelSmppDestAddrTon", dataSm.getDestAddrTon());
        smppMessage.setHeader("CamelSmppServiceType", dataSm.getServiceType());
        smppMessage.setHeader("CamelSmppRegisteredDelivery", dataSm.getRegisteredDelivery());
        smppMessage.setHeader("CamelSmppDataCoding", dataSm.getDataCoding());
        return smppMessage;
    }

    Date getCurrentDate() {
        return new Date();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmppConfiguration configuration) {
        this.configuration = configuration;
    }
}

