/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.smooks.SmooksConstants;
import org.apache.camel.component.smooks.SmooksProcessor;
import org.apache.camel.component.smooks.SmooksProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="4.7.0", scheme="smooks", title="Smooks", syntax="smooks:smooksConfig", producerOnly=true, category={Category.TRANSFORMATION}, headersClass=SmooksConstants.class)
public class SmooksEndpoint
extends DefaultEndpoint {
    @UriPath(description="Path to the Smooks configuration file")
    @Metadata(required=true, supportFileReference=true)
    private String smooksConfig;
    @UriParam(description="File path to place the generated HTML execution report. The report is a useful tool in the developer\u2019s arsenal for diagnosing issues or comprehending a transformation. Do not set in production since this is a major performance drain")
    private String reportPath;
    @UriParam(description="Allow execution context to be set from the CamelSmooksExecutionContext header", label="advanced", defaultValue="false")
    private Boolean allowExecutionContextFromHeader = false;
    private final SmooksProcessor smooksProcessor;

    public SmooksEndpoint(String endpointUri, Component component, SmooksProcessor processor) {
        super(endpointUri, component);
        this.smooksProcessor = processor;
    }

    public Producer createProducer() {
        return new SmooksProducer((Endpoint)this, this.smooksProcessor);
    }

    public Consumer createConsumer(Processor processor) {
        throw new IllegalArgumentException("Consumer is not supported");
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.smooksProcessor);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.smooksProcessor);
    }

    public String getSmooksConfig() {
        return this.smooksConfig;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.smooksConfig = smooksConfig;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public Boolean getAllowExecutionContextFromHeader() {
        return this.allowExecutionContextFromHeader;
    }

    public void setAllowExecutionContextFromHeader(Boolean allowExecutionContextFromHeader) {
        this.allowExecutionContextFromHeader = allowExecutionContextFromHeader;
    }
}

