/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.WrappedFile;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.Smooks;
import org.smooks.SmooksFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.lookup.ExportsLookup;
import org.smooks.engine.report.HtmlReportGenerator;
import org.smooks.io.payload.Exports;
import org.smooks.io.sink.StreamSink;
import org.smooks.io.source.ByteSource;
import org.smooks.io.source.DOMSource;
import org.smooks.io.source.ReaderSource;
import org.smooks.io.source.URLSource;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SmooksProcessor
extends ServiceSupport
implements Processor,
CamelContextAware {
    private static final TypedKey<Exchange> EXCHANGE_TYPED_KEY = TypedKey.of();
    private static final Logger LOG = LoggerFactory.getLogger(SmooksProcessor.class);
    private SmooksFactory smooksFactory;
    private Smooks smooks;
    private String configUri;
    private String reportPath;
    private Boolean allowExecutionContextFromHeader = false;
    private Boolean lazyStartProducer = false;
    private final Set<VisitorAppender> visitorAppender = new HashSet<VisitorAppender>();
    private final Map<String, Visitor> selectorVisitorMap = new HashMap<String, Visitor>();
    private CamelContext camelContext;

    public SmooksProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public SmooksProcessor(Smooks smooks, CamelContext camelContext) {
        this(camelContext);
        this.smooks = smooks;
    }

    public SmooksProcessor(String configUri, CamelContext camelContext) throws IOException, SAXException {
        this(camelContext);
        this.configUri = configUri;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Boolean getAllowExecutionContextFromHeader() {
        return this.allowExecutionContextFromHeader;
    }

    public void setAllowExecutionContextFromHeader(Boolean allowExecutionContextFromHeader) {
        this.allowExecutionContextFromHeader = allowExecutionContextFromHeader;
    }

    public void process(Exchange exchange) {
        ExecutionContext executionContext = null;
        if (this.allowExecutionContextFromHeader.booleanValue()) {
            executionContext = (ExecutionContext)exchange.getMessage().getHeader("CamelSmooksExecutionContext", ExecutionContext.class);
        }
        if (executionContext == null) {
            executionContext = this.smooks.createExecutionContext();
            Charset charset = ExchangeHelper.getCharset((Exchange)exchange, (boolean)false);
            if (charset != null) {
                executionContext.setContentEncoding(charset.name());
            }
        }
        try {
            executionContext.put(EXCHANGE_TYPED_KEY, (Object)exchange);
            exchange.getIn().setHeader("CamelSmooksExecutionContext", (Object)executionContext);
            this.setUpSmooksReporting(executionContext);
            Exports exports = (Exports)this.smooks.getApplicationContext().getRegistry().lookup((Function)new ExportsLookup());
            if (exports.hasExports()) {
                Sink[] sinks = exports.createSinks();
                this.smooks.filterSource(executionContext, this.getSource(exchange), sinks);
                this.setResultOnBody(exports, sinks, exchange);
            } else {
                OutputStreamBuilder outputStreamBuilder = OutputStreamBuilder.withExchange((Exchange)exchange);
                this.smooks.filterSource(executionContext, this.getSource(exchange), new Sink[]{new StreamSink((OutputStream)outputStreamBuilder)});
                exchange.getMessage().setBody(outputStreamBuilder.build());
            }
        }
        catch (IOException | InvalidPayloadException e) {
            throw new RuntimeCamelException(e);
        }
        finally {
            executionContext.remove(EXCHANGE_TYPED_KEY);
        }
    }

    protected void setResultOnBody(Exports exports, Sink[] sinks, Exchange exchange) {
        Message message = exchange.getMessage();
        List objects = Exports.extractSinks((Sink[])sinks, (Exports)exports);
        if (objects.size() == 1) {
            Object value = objects.get(0);
            message.setBody(value);
        } else {
            message.setBody((Object)objects);
        }
    }

    private void setUpSmooksReporting(ExecutionContext executionContext) {
        if (this.reportPath != null) {
            try {
                executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)new HtmlReportGenerator(this.reportPath, executionContext.getApplicationContext()));
            }
            catch (IOException e) {
                LOG.warn("Cannot generate Smooks Report. The reportPath specified was [{}]. This exception is ignored.", (Object)this.reportPath, (Object)e);
            }
        }
    }

    private Source getSource(Exchange exchange) throws InvalidPayloadException {
        Object payload = exchange.getIn().getBody();
        if (payload instanceof Source) {
            return (Source)payload;
        }
        if (payload instanceof byte[]) {
            return new ByteSource((byte[])payload);
        }
        if (payload instanceof Node) {
            return new DOMSource((Node)payload);
        }
        if (payload instanceof InputStream) {
            return new org.smooks.io.source.StreamSource((InputStream)payload);
        }
        if (payload instanceof Reader) {
            return new ReaderSource((Reader)payload);
        }
        if (payload instanceof WrappedFile) {
            String systemId = new StreamSource((File)((WrappedFile)exchange.getIn().getBody(WrappedFile.class)).getFile()).getSystemId();
            try {
                return new URLSource(URI.create(systemId).toURL());
            }
            catch (MalformedURLException e) {
                throw new SmooksException((Throwable)e);
            }
        }
        if (payload instanceof SAXSource) {
            return new ReaderSource((Reader)((Object)((SAXSource)payload).getXMLReader()));
        }
        return (Source)exchange.getIn().getMandatoryBody(Source.class);
    }

    public String getSmooksConfig() {
        return this.configUri;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.configUri = smooksConfig;
    }

    public SmooksProcessor addVisitor(Visitor visitor, String targetSelector) {
        this.selectorVisitorMap.put(targetSelector, visitor);
        return this;
    }

    public SmooksProcessor addVisitor(VisitorAppender appender) {
        this.visitorAppender.add(appender);
        return this;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public SmooksFactory getSmooksFactory() {
        return this.smooksFactory;
    }

    public void setSmooksFactory(SmooksFactory smooksFactory) {
        this.smooksFactory = smooksFactory;
    }

    private Smooks createSmooks() {
        return this.smooksFactory != null ? this.smooksFactory.createInstance() : new Smooks();
    }

    private void addAppender(Smooks smooks, Set<VisitorAppender> visitorAppenders) {
        for (VisitorAppender appender : visitorAppenders) {
            smooks.addVisitors(appender);
        }
    }

    private void addVisitor(Smooks smooks, Map<String, Visitor> selectorVisitorMap) {
        for (Map.Entry<String, Visitor> entry : selectorVisitorMap.entrySet()) {
            smooks.addVisitor(entry.getValue(), entry.getKey());
        }
    }

    public Boolean getLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    protected void doStart() {
        try {
            if (this.smooks == null) {
                this.smooks = this.createSmooks();
                if (this.configUri != null) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)this.configUri);
                    this.smooks.addResourceConfigs(is);
                }
                this.smooks.getApplicationContext().getRegistry().registerObject(CamelContext.class, () -> this.camelContext);
            }
            this.addAppender(this.smooks, this.visitorAppender);
            this.addVisitor(this.smooks, this.selectorVisitorMap);
            if (!this.lazyStartProducer.booleanValue()) {
                this.smooks.createExecutionContext();
            }
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doStop() {
        if (this.smooks != null) {
            IOHelper.close((Closeable)this.smooks);
            this.smooks = null;
        }
    }

    public String toString() {
        return "SmooksProcessor[configUri=" + this.configUri + "]";
    }
}

