/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.smb.SmbFile;

@Converter(generateLoader=true)
public class SmbConverter {
    private SmbConverter() {
    }

    @Converter(allowNull=true)
    public static InputStream smbToInputStream(SmbFile file, Exchange exchange) throws Exception {
        Object body = file.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof InputStream) {
            InputStream is = (InputStream)body;
            return is;
        }
        if (body instanceof byte[]) {
            byte[] arr = (byte[])body;
            return new ByteArrayInputStream(arr);
        }
        return (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, body);
    }
}

