/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileDirectoryQueryableInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.protocol.commons.EnumWithValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.component.smb.SmbFile;
import org.apache.camel.component.smb.SmbOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbConsumer
extends GenericFileConsumer<FileIdBothDirectoryInformation> {
    private static final Logger LOG = LoggerFactory.getLogger(SmbConsumer.class);
    private final SmbEndpoint endpoint;
    private final SmbConfiguration configuration;
    private final String endpointPath;
    protected transient boolean loggedIn;
    protected transient boolean loggedInWarning;
    protected transient boolean autoCreatedDone;
    protected transient boolean autoCreateWarning;

    public SmbConsumer(SmbEndpoint endpoint, Processor processor, GenericFileOperations<FileIdBothDirectoryInformation> fileOperations, GenericFileProcessStrategy<FileIdBothDirectoryInformation> processStrategy) {
        super((GenericFileEndpoint)endpoint, processor, fileOperations, processStrategy);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.endpointPath = this.configuration.getDirectory() == null ? "" : this.configuration.getDirectory();
        this.setRetrieveFile(this.configuration.isDownload());
    }

    public GenericFileEndpoint<FileIdBothDirectoryInformation> getEndpoint() {
        return (GenericFileEndpoint)super.getEndpoint();
    }

    protected boolean pollDirectory(Exchange dynamic, String path, List<GenericFile<FileIdBothDirectoryInformation>> fileList, int depth) {
        ++depth;
        FileIdBothDirectoryInformation[] files = this.getSmbFiles(path = path == null ? "" : path);
        if (files.length == 0) {
            LOG.trace("No files found in directory: {}", (Object)path);
            return true;
        }
        if (this.getEndpoint().isPreSort()) {
            Arrays.sort(files, Comparator.comparing(FileDirectoryQueryableInformation::getFileName));
        }
        for (FileIdBothDirectoryInformation file : files) {
            if (file.getFileName().equals(".") || file.getFileName().equals("..")) continue;
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            Object fullFilePath = file.getFileName();
            if (!path.isEmpty()) {
                fullFilePath = path + (path.endsWith("/") ? "" : "/") + file.getFileName();
            }
            if (!this.handleSmbEntries(dynamic, (String)fullFilePath, fileList, depth, files, file)) continue;
            return false;
        }
        return true;
    }

    private FileIdBothDirectoryInformation[] getSmbFiles(String dir) {
        LOG.trace("Polling directory: {}", (Object)dir);
        return this.getOperations().listFiles(dir, this.configuration.getSearchPattern());
    }

    private boolean handleSmbEntries(Exchange dynamic, String fullFilePath, List<GenericFile<FileIdBothDirectoryInformation>> fileList, int depth, FileIdBothDirectoryInformation[] files, FileIdBothDirectoryInformation file) {
        if (this.isDirectory(file)) {
            LOG.trace("SmbFile[name={}, dir=true]", (Object)file.getFileName());
            return this.handleDirectory(dynamic, fullFilePath, fileList, depth, files, file);
        }
        LOG.trace("SmbFile[name={}, file=true]", (Object)file.getFileName());
        this.handleFile(dynamic, fullFilePath, fileList, depth, files, file);
        return false;
    }

    private boolean handleDirectory(Exchange dynamic, String fullFilePath, List<GenericFile<FileIdBothDirectoryInformation>> fileList, int depth, FileIdBothDirectoryInformation[] files, FileIdBothDirectoryInformation file) {
        if (this.endpoint.isRecursive() && depth < this.endpoint.getMaxDepth()) {
            SmbFile smbFile = this.asGenericFile(fullFilePath, file, this.getEndpoint().getCharset());
            Supplier genericFileSupplier = Suppliers.memorize(() -> smbFile);
            Supplier<String> relativePath = () -> ((SmbFile)smbFile).getRelativeFilePath();
            if (this.isValidFile(dynamic, genericFileSupplier, file.getFileName(), smbFile.getAbsoluteFilePath(), relativePath, true, files)) {
                boolean canPollMore = this.pollDirectory(dynamic, fullFilePath, fileList, depth);
                return !canPollMore;
            }
        }
        return false;
    }

    private void handleFile(Exchange dynamic, String fullFilePath, List<GenericFile<FileIdBothDirectoryInformation>> fileList, int depth, FileIdBothDirectoryInformation[] files, FileIdBothDirectoryInformation file) {
        if (depth >= this.endpoint.getMinDepth()) {
            SmbFile smbFile = this.asGenericFile(fullFilePath, file, this.getEndpoint().getCharset());
            Supplier genericFileSupplier = Suppliers.memorize(() -> smbFile);
            Supplier<String> relativePath = () -> ((SmbFile)smbFile).getRelativeFilePath();
            if (this.isValidFile(dynamic, genericFileSupplier, file.getFileName(), smbFile.getAbsoluteFilePath(), relativePath, false, files)) {
                fileList.add(smbFile);
            }
        }
    }

    protected Exchange createExchange(GenericFile<FileIdBothDirectoryInformation> file) {
        Exchange exchange = this.createExchange(true);
        if (file != null) {
            file.bindToExchange(exchange);
        }
        return exchange;
    }

    protected void updateFileHeaders(GenericFile<FileIdBothDirectoryInformation> file, Message message) {
    }

    protected Supplier<String> getRelativeFilePath(String endpointPath, String path, String absolutePath, FileIdBothDirectoryInformation file) {
        return () -> {
            String relativePath = StringHelper.after((String)absolutePath, (String)endpointPath);
            return FileUtil.stripLeadingSeparator((String)relativePath);
        };
    }

    protected boolean isMatched(Supplier<GenericFile<FileIdBothDirectoryInformation>> file, String doneFileName, FileIdBothDirectoryInformation[] files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (FileIdBothDirectoryInformation f : files) {
            if (!f.getFileName().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    protected boolean prePollCheck() throws Exception {
        block9: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("prePollCheck on {}", this.getEndpoint());
            }
            try {
                this.getOperations().connectIfNecessary();
                this.loggedIn = true;
                if (!this.autoCreatedDone) {
                    this.autoCreateIfNecessary();
                    this.autoCreatedDone = true;
                }
            }
            catch (Exception e) {
                Exception cause = e;
                String msg = "Cannot connect/login to: " + this.remoteServer();
                if (this.loggedIn && !this.autoCreatedDone) {
                    msg = "Cannot auto-create starting directory at: " + this.remoteServer();
                }
                LOG.debug(msg, (Throwable)cause);
                this.loggedIn = false;
                if (!this.configuration.isThrowExceptionOnConnectFailed()) break block9;
                throw e;
            }
        }
        if (this.loggedIn && !this.autoCreatedDone) {
            String message = "Cannot auto-create starting directory at: " + this.remoteServer() + ". Will skip this poll.";
            if (!this.autoCreateWarning) {
                LOG.warn(message);
                this.autoCreateWarning = true;
            }
            return false;
        }
        if (!this.loggedIn) {
            String message = "Cannot connect/login to: " + this.remoteServer() + ". Will skip this poll.";
            if (!this.loggedInWarning) {
                LOG.warn(message);
                this.loggedInWarning = true;
            }
            return false;
        }
        this.loggedInWarning = false;
        this.forceConsumerAsReady();
        return true;
    }

    protected void autoCreateIfNecessary() throws GenericFileOperationFailedException {
        if (this.endpoint.isAutoCreate() && this.hasStartingDirectory()) {
            String dir = this.endpoint.getConfiguration().getDirectory();
            LOG.debug("Auto creating directory: {}", (Object)dir);
            this.operations.buildDirectory(dir, true);
        }
    }

    protected String remoteServer() {
        return this.configuration.remoteServerInformation();
    }

    protected void disconnect() {
        block4: {
            this.loggedIn = false;
            try {
                if (this.getOperations().isConnected()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Disconnecting from: {}", (Object)this.remoteServer());
                    }
                    this.getOperations().disconnect();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Error occurred while disconnecting from {} due: {} This exception will be ignored.", new Object[]{this.remoteServer(), e.getMessage(), e});
            }
        }
    }

    protected void postPollCheck(int polledMessages) {
        if (polledMessages == 0 && this.configuration.isDisconnect()) {
            LOG.trace("postPollCheck disconnect from: {}", this.getEndpoint());
            this.disconnect();
        }
    }

    protected boolean processExchange(Exchange exchange) {
        boolean isLast = (Boolean)exchange.getProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)true, Boolean.class);
        if (isLast && this.configuration.isDisconnect()) {
            exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    LOG.trace("processExchange disconnect from: {}", SmbConsumer.this.getEndpoint());
                    SmbConsumer.this.disconnect();
                }

                public boolean allowHandover() {
                    return false;
                }

                public int getOrder() {
                    return 2147482647;
                }

                public String toString() {
                    return "Disconnect";
                }
            });
        }
        return super.processExchange(exchange);
    }

    private SmbFile asGenericFile(String path, FileIdBothDirectoryInformation file, String charset) {
        SmbFile genericFile = new SmbFile(this.getOperations(), this.configuration.isDownload(), this.configuration.isStreamDownload());
        genericFile.setHostname(this.configuration.getHostname());
        genericFile.setFile(file);
        genericFile.setEndpointPath(this.endpointPath);
        genericFile.setLastModified(file.getLastWriteTime().toEpochMillis());
        genericFile.setCharset(charset);
        genericFile.setFileNameOnly(file.getFileName());
        genericFile.setDirectory(this.isDirectory(file));
        genericFile.setFileLength(file.getEndOfFile());
        boolean absolute = FileUtil.hasLeadingSeparator((String)path);
        genericFile.setAbsolute(absolute);
        Object absoluteFileName = FileUtil.stripLeadingSeparator((String)path);
        if (absolute) {
            absoluteFileName = "/" + (String)absoluteFileName;
        }
        genericFile.setAbsoluteFilePath((String)absoluteFileName);
        String relativePath = StringHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        genericFile.setRelativeFilePath(relativePath);
        genericFile.setFileName(relativePath);
        return genericFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        boolean startScheduler = this.isStartScheduler();
        this.setStartScheduler(false);
        try {
            String dir;
            SmbOperations ops;
            boolean exists;
            super.doStart();
            if (this.endpoint.isAutoCreate() && this.hasStartingDirectory()) {
                String dir2 = this.endpoint.getConfiguration().getDirectory();
                LOG.debug("Auto creating directory: {}", (Object)dir2);
                try {
                    this.operations.buildDirectory(dir2, true);
                }
                catch (GenericFileOperationFailedException e) {
                    LOG.warn("Error auto creating directory: " + dir2 + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            } else if (this.configuration.isStartingDirectoryMustExist() && this.hasStartingDirectory() && !(exists = (ops = (SmbOperations)this.operations).existsFolder(dir = this.endpoint.getConfiguration().getDirectory()))) {
                throw new GenericFileOperationFailedException("Starting directory does not exist: " + dir);
            }
        }
        finally {
            if (startScheduler) {
                this.setStartScheduler(true);
                this.startScheduler();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    private SmbOperations getOperations() {
        return (SmbOperations)this.operations;
    }

    private boolean hasStartingDirectory() {
        String dir = this.endpoint.getConfiguration().getDirectory();
        if (ObjectHelper.isEmpty((String)dir)) {
            return false;
        }
        return !dir.equals("/") && !dir.equals("\\");
    }

    private boolean isDirectory(FileIdBothDirectoryInformation file) {
        return EnumWithValue.EnumUtils.isSet((long)file.getFileAttributes(), (EnumWithValue)FileAttributes.FILE_ATTRIBUTE_DIRECTORY);
    }
}

