/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.GenericFileComponent;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="smb")
public class SmbComponent
extends GenericFileComponent<FileIdBothDirectoryInformation> {
    private static final Logger LOG = LoggerFactory.getLogger(SmbComponent.class);
    public static final String SMB_FILE_INPUT_STREAM = "CamelSmbFileInputStream";

    public SmbComponent() {
    }

    public SmbComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<FileIdBothDirectoryInformation> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        SmbConfiguration config = new SmbConfiguration(new URI(baseUri));
        String path = (String)this.getAndRemoveParameter(parameters, "path", String.class);
        if (path != null) {
            config.setPath(path);
            LOG.warn("The path option should be specified in the context-path. Instead of using ?path=/mypath then specify this in the context-path in uri: " + uri);
        }
        if (config.getShareName() == null) {
            throw new IllegalArgumentException("ShareName must be configured");
        }
        SmbEndpoint endpoint = new SmbEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void afterPropertiesSet(GenericFileEndpoint<FileIdBothDirectoryInformation> endpoint) throws Exception {
    }

    protected String getBaseUri(String uri) {
        return StringHelper.before((String)uri, (String)"?", (String)uri);
    }
}

