/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.protocol.transport.TransportException;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.utils.SmbFiles;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.EnumSet;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.component.smb.SmbFile;
import org.apache.camel.component.smb.SmbFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbOperations
implements SmbFileOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SmbOperations.class);
    private final SmbConfiguration configuration;
    private SmbEndpoint endpoint;
    private boolean loggedIn;
    private Session session;
    private DiskShare share;
    private SMBClient smbClient;
    private Connection connection;

    public SmbOperations(SmbConfiguration configuration) {
        this.configuration = configuration;
        this.smbClient = configuration == null || configuration.getSmbConfig() == null ? new SMBClient() : new SMBClient(configuration.getSmbConfig());
    }

    @Override
    public boolean connect(SmbConfiguration configuration, Exchange exchange) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        return true;
    }

    protected void connectIfNecessary() {
        try {
            if (!this.isConnected()) {
                LOG.debug("Not already connected/logged in. Connecting to: {}:{}", (Object)this.configuration.getHostname(), (Object)this.configuration.getPort());
                this.disconnect();
                this.connection = this.smbClient.connect(this.configuration.getHostname(), this.configuration.getPort());
                AuthenticationContext ac = new AuthenticationContext(this.configuration.getUsername(), this.configuration.getPassword().toCharArray(), this.configuration.getDomain());
                this.session = this.connection.authenticate(ac);
                this.share = (DiskShare)this.session.connectShare(this.configuration.getShareName());
                LOG.debug("Connected and logged in to: {}:{}", (Object)this.configuration.getHostname(), (Object)this.configuration.getPort());
                this.loggedIn = true;
            }
        }
        catch (SMBRuntimeException | IOException e) {
            this.disconnect();
            throw new GenericFileOperationFailedException("Cannot connect to: " + this.configuration.getHostname() + ":" + this.configuration.getPort() + " due to: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.loggedIn && this.connection != null && this.connection.isConnected() && this.session != null && this.share != null && this.share.isConnected();
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        this.loggedIn = false;
        if (this.share != null) {
            try {
                this.share.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.share = null;
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (TransportException t) {
                try {
                    this.connection.close(true);
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    @Override
    public void forceDisconnect() throws GenericFileOperationFailedException {
        this.disconnect();
        if (this.smbClient != null) {
            this.smbClient.close();
        }
        this.smbClient = null;
    }

    public GenericFile<FileIdBothDirectoryInformation> newGenericFile() {
        return new SmbFile(this, this.configuration.isDownload(), this.configuration.isStreamDownload());
    }

    public void setEndpoint(GenericFileEndpoint<FileIdBothDirectoryInformation> endpoint) {
        this.endpoint = (SmbEndpoint)endpoint;
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        if (this.share.fileExists(name)) {
            try (File f = this.share.openFile(name, EnumSet.of(AccessMask.DELETE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
                f.deleteOnClose();
            }
        }
        return true;
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        return this.share.fileExists(name);
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        try (File src = this.share.openFile(from, EnumSet.of(AccessMask.GENERIC_READ, AccessMask.DELETE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            try (File dst = this.share.openFile(to, EnumSet.of(AccessMask.GENERIC_WRITE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_CREATE, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));){
                src.remoteCopyTo(dst);
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            src.deleteOnClose();
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
        return true;
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        SmbFiles files = new SmbFiles();
        try {
            files.mkdirs(this.share, this.normalize(directory));
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
        return true;
    }

    public boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        if (ObjectHelper.isNotEmpty((String)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    public boolean existsFolder(String name) {
        this.connectIfNecessary();
        try {
            return this.share.folderExists(name);
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
    }

    private boolean retrieveFileToStreamInBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        SmbFile target = (SmbFile)((Object)exchange.getProperty("CamelFileExchangeFile"));
        ObjectHelper.notNull((Object)((Object)target), (String)"Exchange should have the CamelFileExchangeFile set");
        this.connectIfNecessary();
        try (File shareFile = this.share.openFile(name, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            if (this.configuration.isStreamDownload()) {
                InputStream is = shareFile.getInputStream();
                target.setBody(is);
                exchange.getIn().setHeader("CamelSmbFileInputStream", (Object)is);
            } else {
                try (InputStream is = shareFile.getInputStream();){
                    byte[] body = is.readAllBytes();
                    target.setBody(body);
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
                }
            }
            exchange.getIn().setHeader("CamelSmbUncPath", (Object)shareFile.getUncPath());
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
        return true;
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange) throws GenericFileOperationFailedException {
        java.io.File temp;
        java.io.File local = new java.io.File(this.endpoint.getLocalWorkDirectory());
        SmbFile file = (SmbFile)((Object)exchange.getProperty("CamelFileExchangeFile"));
        ObjectHelper.notNull((Object)((Object)file), (String)"Exchange should have the CamelFileExchangeFile set");
        try {
            String relativeName = file.getRelativeFilePath();
            temp = new java.io.File(local, relativeName + ".inprogress");
            local.mkdirs();
            local = new java.io.File(local, relativeName);
            if (temp.exists() && !FileUtil.deleteFile((java.io.File)temp)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + String.valueOf(temp));
            }
            if (local.exists() && !FileUtil.deleteFile((java.io.File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + String.valueOf(local));
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + String.valueOf(temp));
            }
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + String.valueOf(local), (Throwable)e);
        }
        try {
            file.setBody(local);
            try (File shareFile = this.share.openFile(name, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
                try (InputStream is = shareFile.getInputStream();){
                    Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                exchange.getIn().setHeader("CamelSmbUncPath", (Object)shareFile.getUncPath());
            }
        }
        catch (IOException e) {
            LOG.trace("Error occurred during retrieving file: {} to local directory. Deleting local work file: {}", (Object)name, (Object)temp);
            boolean deleted = FileUtil.deleteFile((java.io.File)temp);
            if (!deleted) {
                LOG.warn("Error occurred during retrieving file: {} to local directory. Cannot delete local work file: {}", (Object)name, (Object)temp);
            }
            this.disconnect();
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        LOG.trace("Renaming local in progress file from: {} to: {}", (Object)temp, (Object)local);
        try {
            if (!FileUtil.renameFile((java.io.File)temp, (java.io.File)local, (boolean)false)) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + String.valueOf(temp) + " to: " + String.valueOf(local));
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + String.valueOf(temp) + " to: " + String.valueOf(local), (Throwable)e);
        }
        return true;
    }

    public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        InputStream is = (InputStream)exchange.getIn().getHeader("CamelSmbFileInputStream", InputStream.class);
        if (is != null) {
            try {
                IOHelper.close((Closeable)is);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        return this.doStoreFile(name, exchange);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doStoreFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        LOG.trace("doStoreFile({})", (Object)name);
        GenericFileExist gfe = (GenericFileExist)exchange.getIn().getHeader("CamelSmbFileExists", GenericFileExist.class);
        if (gfe == null) {
            gfe = this.endpoint.getFileExist();
        }
        boolean existFile = false;
        if (gfe == GenericFileExist.Ignore || gfe == GenericFileExist.Fail || gfe == GenericFileExist.Move || gfe == GenericFileExist.Append || gfe == GenericFileExist.Override) {
            existFile = this.share.fileExists(name);
            if (existFile && gfe == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && gfe == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
            if (existFile && gfe == GenericFileExist.Move) {
                this.endpoint.getMoveExistingFileStrategy().moveExistingFile((GenericFileEndpoint)this.endpoint, (GenericFileOperations)this, name);
            }
        }
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (!this.endpoint.isAllowNullBody()) {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
            LOG.trace("Writing empty file.");
            is = new ByteArrayInputStream(new byte[0]);
        }
        try {
            File shareFile;
            if (is == null) {
                String charset = this.endpoint.getCharset();
                if (charset != null) {
                    is = new ByteArrayInputStream(((String)exchange.getIn().getMandatoryBody(String.class)).getBytes(charset));
                    LOG.trace("Using InputStream {} with charset {}.", (Object)is, (Object)charset);
                } else {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
            }
            StopWatch watch = new StopWatch();
            LOG.debug("About to store file: {} using stream: {}", (Object)name, is);
            if (existFile && gfe == GenericFileExist.Append) {
                LOG.trace("Client appendFile: {}", (Object)name);
                shareFile = this.share.openFile(name, EnumSet.of(AccessMask.FILE_WRITE_DATA), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN_IF, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
                try {
                    this.writeToFile(name, shareFile, is);
                }
                finally {
                    if (shareFile != null) {
                        shareFile.close();
                    }
                }
            }
            if (existFile && gfe == GenericFileExist.Override) {
                LOG.trace("Client overrideFile: {}", (Object)name);
                shareFile = this.share.openFile(name, EnumSet.of(AccessMask.FILE_WRITE_DATA), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
                try {
                    this.writeToFile(name, shareFile, is);
                }
                finally {
                    if (shareFile != null) {
                        shareFile.close();
                    }
                }
            }
            LOG.trace("Client createFile: {}", (Object)name);
            this.createDirectory(this.share, name);
            shareFile = this.share.openFile(name, EnumSet.of(AccessMask.FILE_WRITE_DATA), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_CREATE, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
            try {
                this.writeToFile(name, shareFile, is);
            }
            finally {
                if (shareFile != null) {
                    shareFile.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                long time = watch.taken();
                LOG.debug("Took {} ({} millis) to store file: {}", new Object[]{TimeUtils.printDuration((long)time, (boolean)true), time, name});
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
                catch (InvalidPayloadException e2) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(is, (String)("store: " + name), (Logger)LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is, (String)("store: " + name), (Logger)LOG);
        return bl;
    }

    public void createDirectory(DiskShare share, String fileName) {
        String parentDir = FileUtil.onlyPath((String)fileName);
        boolean dirExists = share.folderExists(parentDir);
        if (!dirExists) {
            if (this.endpoint.isAutoCreate()) {
                SmbFiles files = new SmbFiles();
                files.mkdirs(share, this.normalize(parentDir));
            } else {
                throw new RuntimeCamelException("Directory " + parentDir + " does not exist on share " + String.valueOf(share));
            }
        }
    }

    private void writeToFile(String fileName, File shareFile, InputStream is) throws IOException {
        int length;
        int buffer = this.endpoint.getBufferSize();
        byte[] byteBuffer = new byte[buffer];
        while ((length = is.read(byteBuffer)) > 0) {
            long fileOffset = this.share.getFileInformation(fileName).getStandardInformation().getEndOfFile();
            shareFile.write(byteBuffer, fileOffset, 0, length);
        }
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return null;
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
    }

    public FileIdBothDirectoryInformation[] listFiles() throws GenericFileOperationFailedException {
        return this.listFiles("/");
    }

    public FileIdBothDirectoryInformation[] listFiles(String path) throws GenericFileOperationFailedException {
        return this.listFiles(path, null);
    }

    public FileIdBothDirectoryInformation[] listFiles(String path, String searchPattern) throws GenericFileOperationFailedException {
        this.connectIfNecessary();
        try {
            return (FileIdBothDirectoryInformation[])this.share.list(path, searchPattern).toArray(FileIdBothDirectoryInformation[]::new);
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] getBody(String path) {
        this.connectIfNecessary();
        try (File shareFile = this.share.openFile(path, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            byte[] byArray;
            block16: {
                InputStream is = shareFile.getInputStream();
                try {
                    byArray = is.readAllBytes();
                    if (is == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
                    }
                }
                is.close();
            }
            return byArray;
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
    }

    public InputStream getBodyAsInputStream(Exchange exchange, String path) {
        InputStream is;
        this.connectIfNecessary();
        try {
            File shareFile = this.share.openFile(path, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);
            is = shareFile.getInputStream();
            exchange.getIn().setHeader("CamelSmbFileInputStream", (Object)is);
            exchange.getIn().setHeader("CamelSmbUncPath", (Object)shareFile.getUncPath());
        }
        catch (SMBRuntimeException smbre) {
            this.safeDisconnect(smbre);
            throw smbre;
        }
        return is;
    }

    private void safeDisconnect(SMBRuntimeException smbre) {
        if (smbre.getCause() instanceof TransportException) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String normalize(String file) {
        return file.replace('\\', this.endpoint.getFileSeparator());
    }
}

