/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb.strategy;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.util.Date;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.smb.SmbOperations;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbExclusiveReadLockCheck {
    private static final Logger LOG = LoggerFactory.getLogger(SmbExclusiveReadLockCheck.class);
    private final long startTime = new Date().getTime();
    private final long minAge;
    private final long minLength;
    private final StopWatch watch;
    private long lastModified;
    private long length;

    public SmbExclusiveReadLockCheck(long minAge, long minLength) {
        this.minAge = minAge;
        this.minLength = minLength;
        this.watch = new StopWatch();
        this.lastModified = Long.MIN_VALUE;
        this.length = Long.MIN_VALUE;
    }

    public boolean tryAcquireExclusiveReadLock(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file) {
        long newLastModified = 0L;
        long newLength = 0L;
        FileIdBothDirectoryInformation[] files = this.getSmbFiles(operations, file);
        LOG.trace("List files {} found {} files", (Object)file.getAbsoluteFilePath(), (Object)files.length);
        for (FileIdBothDirectoryInformation f : files) {
            boolean match = f.getFileName().equals(file.getFileNameOnly());
            if (!match) continue;
            newLength = f.getEndOfFile();
            newLastModified = f.getChangeTime().toEpochMillis();
        }
        LOG.trace("Previous last modified: {}, new last modified: {}", (Object)this.lastModified, (Object)newLastModified);
        LOG.trace("Previous length: {}, new length: {}", (Object)this.length, (Object)newLength);
        long newOlderThan = this.startTime + this.watch.taken() - this.minAge;
        LOG.trace("New older than threshold: {}", (Object)newOlderThan);
        if (this.isReadLockAcquired(this.lastModified, this.length, newLastModified, newLength, newOlderThan)) {
            LOG.trace("Read lock acquired.");
            return true;
        }
        this.lastModified = newLastModified;
        this.length = newLength;
        return false;
    }

    private FileIdBothDirectoryInformation[] getSmbFiles(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file) {
        String path = file.getParent();
        if (operations instanceof SmbOperations) {
            SmbOperations smbOperations = (SmbOperations)operations;
            return smbOperations.listFiles(path, file.getFileName());
        }
        return (FileIdBothDirectoryInformation[])operations.listFiles(path);
    }

    private boolean isReadLockAcquired(long lastModified, long length, long newLastModified, long newLength, long newOlderThan) {
        return newLength >= this.minLength && (this.minAge == 0L && newLastModified == lastModified && newLength == length || this.minAge != 0L && newLastModified < newOlderThan);
    }
}

