/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms2;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Sjms2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":destinationType:destinationName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "sjms2".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "destinationType", "queue", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "destinationName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(50);
        props.add("acknowledgementMode");
        props.add("allowNullBody");
        props.add("asyncConsumer");
        props.add("asyncStartListener");
        props.add("asyncStopListener");
        props.add("autoStartup");
        props.add("bridgeErrorHandler");
        props.add("clientId");
        props.add("concurrentConsumers");
        props.add("connectionFactory");
        props.add("deliveryMode");
        props.add("deliveryPersistent");
        props.add("destinationCreationStrategy");
        props.add("destinationName");
        props.add("destinationType");
        props.add("disableReplyTo");
        props.add("disableTimeToLive");
        props.add("durable");
        props.add("durableSubscriptionName");
        props.add("eagerLoadingOfProperties");
        props.add("eagerPoisonBody");
        props.add("exceptionHandler");
        props.add("exceptionListener");
        props.add("exchangePattern");
        props.add("explicitQosEnabled");
        props.add("headerFilterStrategy");
        props.add("includeAllJMSXProperties");
        props.add("jmsKeyFormatStrategy");
        props.add("jmsMessageType");
        props.add("lazyStartProducer");
        props.add("mapJmsMessage");
        props.add("messageCreatedStrategy");
        props.add("messageSelector");
        props.add("preserveMessageQos");
        props.add("priority");
        props.add("recoveryInterval");
        props.add("replyTo");
        props.add("replyToConcurrentConsumers");
        props.add("replyToDeliveryPersistent");
        props.add("replyToOverride");
        props.add("replyToSameDestinationAllowed");
        props.add("replyToType");
        props.add("requestTimeout");
        props.add("shared");
        props.add("subscriptionId");
        props.add("synchronous");
        props.add("testConnectionOnStartup");
        props.add("timeToLive");
        props.add("transacted");
        props.add("transferException");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

