/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.SessionCallback;
import org.apache.camel.component.sjms.SessionMessageListener;
import org.apache.camel.component.sjms.SjmsConsumer;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.SjmsTemplate;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointMessageListener
implements SessionMessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointMessageListener.class);
    private final SjmsConsumer consumer;
    private final SjmsEndpoint endpoint;
    private final AsyncProcessor processor;
    private Object replyToDestination;
    private boolean disableReplyTo;
    private boolean async;
    private boolean eagerLoadingOfProperties;
    private String eagerPoisonBody;
    private volatile SjmsTemplate template;
    private final Lock lock = new ReentrantLock();

    public EndpointMessageListener(SjmsConsumer consumer, SjmsEndpoint endpoint, Processor processor) {
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    public SjmsTemplate getTemplate() {
        this.lock.lock();
        try {
            if (this.template == null) {
                this.template = this.endpoint.createInOnlyTemplate();
            }
            SjmsTemplate sjmsTemplate = this.template;
            return sjmsTemplate;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTemplate(SjmsTemplate template) {
        this.template = template;
    }

    public Object getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public String getEagerPoisonBody() {
        return this.eagerPoisonBody;
    }

    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.eagerPoisonBody = eagerPoisonBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(jakarta.jms.Message message, Session session) {
        RuntimeCamelException rce;
        LOG.trace("onMessage START");
        LOG.debug("{} consumer received JMS message: {}", (Object)this.endpoint, (Object)message);
        try {
            boolean forceSync;
            String correlationId;
            Object replyDestination = this.getReplyToDestination(message);
            boolean sendReply = replyDestination != null && !this.disableReplyTo;
            Destination destination = JmsMessageHelper.getJMSDestination(message);
            if (destination != null && sendReply && !this.endpoint.isReplyToSameDestinationAllowed() && destination.equals(replyDestination)) {
                LOG.debug("JMSDestination and JMSReplyTo is the same, will skip sending a reply message to itself: {}", (Object)destination);
                sendReply = false;
            }
            Exchange exchange = this.createExchange(message, session, replyDestination);
            if (ObjectHelper.isNotEmpty((String)this.eagerPoisonBody) && this.eagerLoadingOfProperties) {
                try {
                    exchange.getIn().getBody();
                    exchange.getIn().getHeaders();
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                    String text = this.eagerPoisonBody;
                    try {
                        text = (String)this.endpoint.getCamelContext().resolveLanguage("simple").createExpression(this.eagerPoisonBody).evaluate(exchange, String.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    exchange.getIn().setBody((Object)text);
                }
            } else if (this.eagerLoadingOfProperties) {
                exchange.getIn().getBody();
                exchange.getIn().getHeaders();
            }
            if ((correlationId = message.getJMSCorrelationID()) != null) {
                LOG.debug("Received Message has JMSCorrelationID [{}]", (Object)correlationId);
            }
            LOG.trace("onMessage.process START");
            EndpointMessageListenerAsyncCallback callback = new EndpointMessageListenerAsyncCallback(session, message, exchange, this.endpoint, sendReply, replyDestination);
            boolean bl = forceSync = this.endpoint.isSynchronous() || this.endpoint.isTransacted();
            if (forceSync || !this.isAsync()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchange {} synchronously", (Object)exchange.getExchangeId());
                }
                try {
                    this.processor.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                finally {
                    callback.done(true);
                }
            } else {
                boolean sync;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchange {} asynchronously", (Object)exchange.getExchangeId());
                }
                if (!(sync = this.processor.process(exchange, (AsyncCallback)callback))) {
                    return;
                }
            }
            rce = (RuntimeCamelException)exchange.getException(RuntimeCamelException.class);
            this.consumer.releaseExchange(exchange, false);
        }
        catch (Exception e) {
            rce = RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (rce != null) {
            LOG.trace("onMessage END throwing exception: {}", (Object)rce.getMessage());
            throw rce;
        }
        LOG.trace("onMessage END");
    }

    protected Object getReplyToDestination(jakarta.jms.Message message) {
        Object destination = this.getReplyToDestination();
        if (destination == null) {
            destination = JmsMessageHelper.getJMSReplyTo(message);
        }
        return destination;
    }

    public Exchange createExchange(jakarta.jms.Message message, Session session, Object replyDestination) {
        Exchange exchange = this.consumer.createExchange(false);
        Message msg = exchange.getIn();
        if (msg instanceof SjmsMessage) {
            SjmsMessage jm = (SjmsMessage)msg;
            jm.init(exchange, message, session, this.endpoint.getBinding());
        } else {
            exchange.setIn((Message)new SjmsMessage(exchange, message, session, this.endpoint.getBinding()));
        }
        if (replyDestination != null && !this.disableReplyTo && !exchange.getPattern().isOutCapable()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        exchange.setProperty("CamelJMSSession", (Object)session);
        return exchange;
    }

    protected void sendReply(Session session, Destination replyDestination, jakarta.jms.Message message, Exchange exchange, Message out, Exception cause) {
        if (replyDestination == null) {
            LOG.debug("Cannot send reply message as there is no replyDestination for: {}", (Object)out);
            return;
        }
        try {
            SessionCallback callback = this.createSessionCallback(replyDestination, message, exchange, out, cause, this.endpoint.getJmsObjectFactory()::createMessageProducer);
            this.getTemplate().execute(session, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Unable to send reply JMS message", exchange, (Throwable)e));
        }
    }

    private <T> SessionCallback createSessionCallback(final T replyDestination, final jakarta.jms.Message message, final Exchange exchange, final Message out, final Exception cause, final MessageProducerCreator<T> messageProducerCreator) {
        return new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInJms(Session session) throws Exception {
                MessageProducer producer = null;
                try {
                    jakarta.jms.Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session, cause);
                    String correlationID = EndpointMessageListener.this.determineCorrelationId(message);
                    reply.setJMSCorrelationID(correlationID);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} sending reply JMS message [correlationId:{}]: {}", new Object[]{EndpointMessageListener.this.endpoint, correlationID, reply});
                    }
                    producer = messageProducerCreator.create(session, (Endpoint)EndpointMessageListener.this.endpoint, replyDestination);
                    EndpointMessageListener.this.template.send(producer, reply);
                }
                catch (Throwable throwable) {
                    EndpointMessageListener.close(producer);
                    throw throwable;
                }
                EndpointMessageListener.close(producer);
                return null;
            }

            @Override
            public void onClose(Connection connection, Session session) {
            }
        };
    }

    protected void sendReply(Session session, String replyDestination, jakarta.jms.Message message, Exchange exchange, Message out, Exception cause) {
        if (replyDestination == null) {
            LOG.debug("Cannot send reply message as there is no replyDestination for: {}", (Object)out);
            return;
        }
        try {
            SessionCallback callback = this.createSessionCallback(replyDestination, message, exchange, out, cause, this.endpoint.getJmsObjectFactory()::createMessageProducer);
            this.getTemplate().execute(session, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Unable to send reply JMS message", exchange, (Throwable)e));
        }
    }

    protected String determineCorrelationId(jakarta.jms.Message message) throws JMSException {
        String messageId = message.getJMSMessageID();
        String correlationId = message.getJMSCorrelationID();
        if (ObjectHelper.isEmpty((String)correlationId)) {
            return messageId;
        }
        return correlationId;
    }

    protected static void close(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class EndpointMessageListenerAsyncCallback
    implements AsyncCallback {
        private final Session session;
        private final jakarta.jms.Message message;
        private final Exchange exchange;
        private final SjmsEndpoint endpoint;
        private final boolean sendReply;
        private final Object replyDestination;

        private EndpointMessageListenerAsyncCallback(Session session, jakarta.jms.Message message, Exchange exchange, SjmsEndpoint endpoint, boolean sendReply, Object replyDestination) {
            this.session = session;
            this.message = message;
            this.exchange = exchange;
            this.endpoint = endpoint;
            this.sendReply = sendReply;
            this.replyDestination = replyDestination;
        }

        public void done(boolean doneSync) {
            LOG.trace("onMessage.process END");
            Message body = null;
            Exception cause = null;
            RuntimeCamelException rce = null;
            if (this.exchange.isFailed() || this.exchange.isRollbackOnly()) {
                if (this.exchange.isRollbackOnly()) {
                    rce = RuntimeCamelException.wrapRuntimeCamelException((Throwable)new RollbackExchangeException(this.exchange));
                } else if (this.exchange.getException() != null) {
                    if (this.endpoint.isTransferException()) {
                        body = null;
                        cause = this.exchange.getException();
                    } else {
                        rce = RuntimeCamelException.wrapRuntimeCamelException((Throwable)this.exchange.getException());
                    }
                }
            } else if (this.sendReply && this.exchange.getPattern().isOutCapable()) {
                body = this.exchange.getMessage();
                cause = null;
            }
            if (rce == null && this.sendReply && (body != null || cause != null)) {
                LOG.trace("onMessage.sendReply START");
                if (this.replyDestination instanceof Destination) {
                    EndpointMessageListener.this.sendReply(this.session, (Destination)this.replyDestination, this.message, this.exchange, body, cause);
                } else {
                    EndpointMessageListener.this.sendReply(this.session, (String)this.replyDestination, this.message, this.exchange, body, cause);
                }
                LOG.trace("onMessage.sendReply END");
            }
            if (rce != null) {
                if (doneSync) {
                    this.exchange.setException((Throwable)rce);
                } else if (this.endpoint.getExceptionHandler() != null) {
                    this.endpoint.getExceptionHandler().handleException((Throwable)rce);
                }
            }
            if (!doneSync) {
                EndpointMessageListener.this.consumer.releaseExchange(this.exchange, false);
            }
        }
    }

    @FunctionalInterface
    private static interface MessageProducerCreator<T> {
        public MessageProducer create(Session var1, Endpoint var2, T var3) throws Exception;
    }
}

