/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.MessageConsumerResources;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class InOutProducer
extends SjmsProducer {
    private static final Map<String, Exchanger<Object>> EXCHANGERS = new ConcurrentHashMap<String, Exchanger<Object>>();
    private GenericObjectPool<MessageConsumerResources> consumers;

    public InOutProducer(SjmsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getNamedReplyTo())) {
            this.log.debug("No reply to destination is defined.  Using temporary destinations.");
        } else {
            this.log.debug("Using {} as the reply to destination.", (Object)this.getNamedReplyTo());
        }
        if (this.getConsumers() == null) {
            this.setConsumers((GenericObjectPool<MessageConsumerResources>)new GenericObjectPool((PoolableObjectFactory)new MessageConsumerResourcesFactory()));
            this.getConsumers().setMaxActive(this.getConsumerCount());
            this.getConsumers().setMaxIdle(this.getConsumerCount());
            while (this.getConsumers().getNumIdle() < this.getConsumers().getMaxIdle()) {
                this.getConsumers().addObject();
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.getConsumers() != null) {
            this.getConsumers().close();
            this.setConsumers(null);
        }
    }

    @Override
    public MessageProducerResources doCreateProducerModel() throws Exception {
        MessageProducerResources answer;
        Connection conn = this.getConnectionResource().borrowConnection();
        try {
            Session session = conn.createSession(this.isEndpointTransacted(), this.getAcknowledgeMode());
            Destination destination = this.getEndpoint().getDestinationCreationStrategy().createDestination(session, this.getDestinationName(), this.isTopic());
            MessageProducer messageProducer = JmsObjectFactory.createMessageProducer(session, destination, this.isPersistent(), this.getTtl());
            answer = new MessageProducerResources(session, messageProducer);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageProducer", (Throwable)e);
            throw e;
        }
        finally {
            this.getConnectionResource().returnConnection(conn);
        }
        return answer;
    }

    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, MessageProducerResources producer) throws Exception {
        if (this.isEndpointTransacted()) {
            exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), this.getCommitStrategy()));
        }
        Message request = JmsMessageHelper.createMessage(exchange, producer.getSession(), this.getEndpoint());
        String correlationId = exchange.getIn().getHeader("JMSCorrelationID", String.class) == null ? UUID.randomUUID().toString().replace("-", "") : (String)exchange.getIn().getHeader("JMSCorrelationID", String.class);
        Object responseObject = null;
        Exchanger<Object> messageExchanger = new Exchanger<Object>();
        JmsMessageHelper.setCorrelationId(request, correlationId);
        EXCHANGERS.put(correlationId, messageExchanger);
        MessageConsumerResources consumer = (MessageConsumerResources)this.consumers.borrowObject();
        JmsMessageHelper.setJMSReplyTo(request, consumer.getReplyToDestination());
        this.consumers.returnObject((Object)consumer);
        producer.getMessageProducer().send(request);
        try {
            this.getProducers().returnObject((Object)producer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            responseObject = messageExchanger.exchange(null, this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
            EXCHANGERS.remove(correlationId);
        }
        catch (InterruptedException e) {
            this.log.debug("Exchanger was interrupted while waiting on response", (Throwable)e);
            exchange.setException((Throwable)e);
        }
        catch (TimeoutException e) {
            this.log.debug("Exchanger timed out while waiting on response", (Throwable)e);
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() == null) {
            if (responseObject instanceof Throwable) {
                exchange.setException((Throwable)responseObject);
            } else if (responseObject instanceof Message) {
                Message response = responseObject;
                JmsMessageHelper.populateExchange(response, exchange, true, this.getEndpoint().getJmsKeyFormatStrategy());
            } else {
                exchange.setException((Throwable)new CamelException("Unknown response type: " + responseObject));
            }
        }
        callback.done(this.isSynchronous());
    }

    public void setConsumers(GenericObjectPool<MessageConsumerResources> consumers) {
        this.consumers = consumers;
    }

    public GenericObjectPool<MessageConsumerResources> getConsumers() {
        return this.consumers;
    }

    protected class MessageConsumerResourcesFactory
    extends BasePoolableObjectFactory<MessageConsumerResources> {
        protected MessageConsumerResourcesFactory() {
        }

        public MessageConsumerResources makeObject() throws Exception {
            MessageConsumerResources answer;
            Connection conn = InOutProducer.this.getConnectionResource().borrowConnection();
            try {
                Session session = InOutProducer.this.isEndpointTransacted() ? conn.createSession(true, 0) : conn.createSession(false, 1);
                Destination replyToDestination = ObjectHelper.isEmpty((Object)InOutProducer.this.getNamedReplyTo()) ? InOutProducer.this.getEndpoint().getDestinationCreationStrategy().createTemporaryDestination(session, InOutProducer.this.isTopic()) : InOutProducer.this.getEndpoint().getDestinationCreationStrategy().createDestination(session, InOutProducer.this.getNamedReplyTo(), InOutProducer.this.isTopic());
                MessageConsumer messageConsumer = JmsObjectFactory.createMessageConsumer(session, replyToDestination, null, InOutProducer.this.isTopic(), null, true);
                messageConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        InOutProducer.this.log.debug("Message Received in the Consumer Pool");
                        InOutProducer.this.log.debug("  Message : {}", (Object)message);
                        try {
                            Exchanger exchanger = (Exchanger)EXCHANGERS.get(message.getJMSCorrelationID());
                            exchanger.exchange(message, InOutProducer.this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            InOutProducer.this.log.error("Unable to exchange message: {}", (Object)message, (Object)e);
                        }
                    }
                });
                answer = new MessageConsumerResources(session, messageConsumer, replyToDestination);
            }
            catch (Exception e) {
                InOutProducer.this.log.error("Unable to create the MessageConsumerResource: " + e.getLocalizedMessage());
                throw new CamelException((Throwable)e);
            }
            finally {
                InOutProducer.this.getConnectionResource().returnConnection(conn);
            }
            return answer;
        }

        public void destroyObject(MessageConsumerResources model) throws Exception {
            if (model.getMessageConsumer() != null) {
                model.getMessageConsumer().close();
            }
            if (model.getSession() != null) {
                if (model.getSession().getTransacted()) {
                    try {
                        model.getSession().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                model.getSession().close();
            }
        }
    }
}

