/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.Map;

public class BatchMessage<T> {
    private T payload;
    private Map<String, Object> headers;

    public BatchMessage(T payload, Map<String, Object> headers) {
        if (payload == null) {
            throw new IllegalArgumentException("Payload may not be null");
        }
        this.payload = payload;
        this.headers = headers;
    }

    public T getPayload() {
        return this.payload;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMessage)) {
            return false;
        }
        BatchMessage other = (BatchMessage)obj;
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    public String toString() {
        return "BatchMessage [payload=" + this.payload + ", headers=" + this.headers + "]";
    }
}

