/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.shiro.security.ShiroSecurityHelper;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.shiro.crypto.cipher.AesCipherService;
import org.apache.shiro.crypto.cipher.CipherService;
import org.apache.shiro.lang.util.ByteSource;

public class ShiroSecurityTokenInjector
implements Processor {
    private byte[] passPhrase;
    private ShiroSecurityToken securityToken;
    private CipherService cipherService = new AesCipherService();
    private boolean base64;

    public ShiroSecurityTokenInjector() {
    }

    public ShiroSecurityTokenInjector(ShiroSecurityToken securityToken, byte[] passPhrase) {
        this();
        this.setSecurityToken(securityToken);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityTokenInjector(ShiroSecurityToken securityToken, byte[] passPhrase, CipherService cipherService) {
        this(securityToken, passPhrase);
        this.cipherService = cipherService;
    }

    public ByteSource encrypt() {
        return ShiroSecurityHelper.encrypt(this.securityToken, this.passPhrase, this.cipherService);
    }

    public void process(Exchange exchange) throws Exception {
        ByteSource bytes = this.encrypt();
        Object token = this.isBase64() ? bytes.toBase64() : bytes;
        exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", token);
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public void setSecurityToken(ShiroSecurityToken securityToken) {
        this.securityToken = securityToken;
    }

    public ShiroSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public CipherService getCipherService() {
        return this.cipherService;
    }

    public void setCipherService(CipherService cipherService) {
        this.cipherService = cipherService;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }
}

