/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.saxon;

import java.util.List;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.saxon.SaxonConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@DeferredContextBinding
public final class SaxonConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SaxonConverterLoader.addTypeConverter(registry, DOMSource.class, NodeInfo.class, false, (type, exchange, value) -> {
            DOMSource answer = SaxonConverter.toDOMSourceFromNodeInfo((NodeInfo)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, DOMSource.class, TinyDocumentImpl.class, false, (type, exchange, value) -> {
            DOMSource answer = SaxonConverter.toDOMSourceFromNodeInfo((TinyDocumentImpl)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, Document.class, NodeInfo.class, false, (type, exchange, value) -> {
            Document answer = SaxonConverter.toDOMDocument((NodeInfo)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, Document.class, TinyDocumentImpl.class, false, (type, exchange, value) -> {
            Document answer = SaxonConverter.toDOMDocument((TinyDocumentImpl)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, Document.class, TinyElementImpl.class, false, (type, exchange, value) -> {
            Document answer = SaxonConverter.toDOMDocument((TinyElementImpl)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, Node.class, NodeInfo.class, false, (type, exchange, value) -> {
            Node answer = SaxonConverter.toDOMNode((NodeInfo)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, Node.class, TinyDocumentImpl.class, false, (type, exchange, value) -> {
            Node answer = SaxonConverter.toDOMNode((TinyDocumentImpl)value);
            return answer;
        });
        SaxonConverterLoader.addTypeConverter(registry, NodeList.class, List.class, false, (type, exchange, value) -> {
            NodeList answer = SaxonConverter.toDOMNodeList((List)value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        SaxonConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> SaxonConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

