/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.salesforce.api.dto.AbstractQueryRecordsBase;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.internal.client.RestClient;

public class QueryResultIterator<T extends AbstractSObjectBase>
implements Iterator<T> {
    private final RestClient restClient;
    private final Map<String, List<String>> requestHeaders;
    private final ObjectMapper objectMapper;
    private final Class<? extends AbstractQueryRecordsBase<T>> responseClass;
    private AbstractQueryRecordsBase<T> queryRecords;
    private Iterator<T> iterator;

    public QueryResultIterator(ObjectMapper objectMapper, Class<? extends AbstractQueryRecordsBase<T>> responseClass, RestClient restClient, Map<String, List<String>> headers, AbstractQueryRecordsBase<T> queryRecords) {
        this.objectMapper = objectMapper;
        this.responseClass = responseClass;
        this.restClient = restClient;
        this.requestHeaders = headers;
        this.queryRecords = queryRecords;
        this.iterator = queryRecords.getRecords().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || this.queryRecords.getDone() == false;
    }

    @Override
    public T next() {
        if (this.iterator.hasNext()) {
            return (T)((AbstractSObjectBase)this.iterator.next());
        }
        if (!this.queryRecords.getDone().booleanValue()) {
            CountDownLatch latch = new CountDownLatch(1);
            ArrayList valueHolder = new ArrayList();
            this.restClient.queryMore(this.queryRecords.getNextRecordsUrl(), this.requestHeaders, (response, headers, exception) -> {
                try {
                    this.queryRecords = (AbstractQueryRecordsBase)this.objectMapper.readValue(response, this.responseClass);
                    this.iterator = this.queryRecords.getRecords().iterator();
                    valueHolder.add((AbstractSObjectBase)this.iterator.next());
                    latch.countDown();
                }
                catch (IOException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
                finally {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            try {
                latch.await();
                return (T)((AbstractSObjectBase)valueHolder.get(0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        throw new NoSuchElementException();
    }
}

