/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.SalesforceMultipleChoicesException;
import org.apache.camel.component.salesforce.api.TypeReferences;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.HttpClientHolder;
import org.apache.camel.component.salesforce.internal.client.SalesforceSecurityHandler;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.client.BufferingResponseListener;
import org.eclipse.jetty.client.ByteBufferRequestContent;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.internal.HttpContentResponse;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBase
extends ServiceSupport
implements SalesforceSession.SalesforceSessionListener,
HttpClientHolder {
    protected static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    protected static final String APPLICATION_XML_UTF8 = "application/xml;charset=utf-8";
    private static final int DEFAULT_TERMINATION_TIMEOUT = 10;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SalesforceHttpClient httpClient;
    protected final SalesforceSession session;
    protected final SalesforceLoginConfig loginConfig;
    protected final String version;
    protected String accessToken;
    protected String instanceUrl;
    private Phaser inflightRequests;
    private final long terminationTimeout;
    private final ObjectMapper objectMapper;

    public AbstractClientBase(String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig) {
        this(version, session, httpClient, loginConfig, 10);
    }

    AbstractClientBase(String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig, int terminationTimeout) {
        this.version = version;
        this.session = session;
        this.httpClient = httpClient;
        this.loginConfig = loginConfig;
        this.terminationTimeout = terminationTimeout;
        this.objectMapper = JsonUtils.createObjectMapper();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.accessToken = this.session.getAccessToken();
        if (this.accessToken == null && !this.loginConfig.isLazyLogin()) {
            try {
                this.accessToken = this.session.login(null);
            }
            catch (SalesforceException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        this.instanceUrl = this.session.getInstanceUrl();
        this.session.addListener(this);
        this.inflightRequests = new Phaser(1);
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.inflightRequests != null) {
            this.inflightRequests.arrive();
            if (!this.inflightRequests.isTerminated()) {
                try {
                    this.inflightRequests.awaitAdvanceInterruptibly(0, this.terminationTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        }
        this.session.removeListener(this);
    }

    @Override
    public void onLogin(String accessToken, String instanceUrl) {
        if (!accessToken.equals(this.accessToken)) {
            this.accessToken = accessToken;
            this.instanceUrl = instanceUrl;
        }
    }

    @Override
    public void onLogout() {
    }

    protected Request getRequest(HttpMethod method, String url, Map<String, List<String>> headers) {
        return this.getRequest(method.asString(), url, headers);
    }

    protected Request getRequest(String method, String url, Map<String, List<String>> headers) {
        HttpRequest request = (HttpRequest)this.httpClient.newHttpRequest(new HttpConversation(), URI.create(url)).method(method).timeout(this.session.getTimeout(), TimeUnit.MILLISECONDS);
        request.getConversation().setAttribute(SalesforceSecurityHandler.CLIENT_ATTRIBUTE, (Object)this);
        AbstractClientBase.addHeadersTo((Request)request, headers);
        return request;
    }

    protected void doHttpRequest(final Request request, final ClientResponseCallback callback) {
        Request.Content content = request.getBody();
        if (content instanceof InputStreamRequestContent) {
            Content.Chunk chunk;
            InputStreamRequestContent inputStreamRequestContent = (InputStreamRequestContent)content;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while (!(chunk = inputStreamRequestContent.read()).isLast()) {
                buffers.add(chunk.getByteBuffer());
            }
            request.body((Request.Content)new ByteBufferRequestContent(buffers.toArray(new ByteBuffer[0])));
            buffers.clear();
        }
        this.inflightRequests.register();
        request.send((Response.CompleteListener)new BufferingResponseListener(this.httpClient.getMaxContentLength()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Result result) {
                try {
                    Response response = result.getResponse();
                    Map<String, String> headers = AbstractClientBase.determineHeadersFrom(response);
                    if (result.isFailed()) {
                        Throwable failure = result.getFailure();
                        if (failure instanceof SalesforceException) {
                            AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(null, headers, (SalesforceException)((Object)((Object)failure))));
                        } else {
                            String msg = String.format("Unexpected error {%s:%s} executing {%s:%s}", response.getStatus(), response.getReason(), request.getMethod(), request.getURI());
                            AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(null, headers, new SalesforceException(msg, response.getStatus(), failure)));
                        }
                    } else {
                        int status = response.getStatus();
                        HttpRequest request2 = (HttpRequest)((HttpRequest)result.getRequest()).getConversation().getAttribute(SalesforceSecurityHandler.AUTHENTICATION_REQUEST_ATTRIBUTE);
                        if (status == 400 && request2 != null) {
                            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                            try {
                                AbstractClientBase.this.session.parseLoginResponse((ContentResponse)contentResponse, this.getContentAsString());
                                String msg = String.format("Unexpected Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                                AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(null, headers, new SalesforceException(msg, null)));
                            }
                            catch (SalesforceException e) {
                                String msg = String.format("Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                                AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(null, headers, new SalesforceException(msg, response.getStatus(), (Throwable)((Object)e))));
                            }
                        } else if (status < 200 || status >= 300) {
                            SalesforceException exception = AbstractClientBase.this.createRestException(response, this.getContentAsInputStream());
                            AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(this.getContentAsInputStream(), headers, exception));
                        } else {
                            AbstractClientBase.this.httpClient.getWorkerPool().execute(() -> callback.onResponse(this.getContentAsInputStream(), headers, null));
                        }
                    }
                }
                finally {
                    AbstractClientBase.this.inflightRequests.arriveAndDeregister();
                }
            }

            public InputStream getContentAsInputStream() {
                if (this.getContent().length == 0) {
                    return null;
                }
                return super.getContentAsInputStream();
            }
        });
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    final List<RestError> readErrorsFrom(InputStream responseContent, ObjectMapper objectMapper) throws IOException {
        List restErrors = (List)objectMapper.readValue(responseContent, TypeReferences.REST_ERROR_LIST_TYPE);
        return restErrors;
    }

    protected abstract void setAccessToken(Request var1);

    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        String reason;
        int statusCode;
        block9: {
            statusCode = response.getStatus();
            reason = response.getReason();
            if (reason == null || reason.isEmpty()) {
                reason = HttpStatus.getMessage((int)statusCode);
            }
            try {
                if (responseContent == null || responseContent.available() <= 0) break block9;
                if (statusCode == 300) {
                    List choices = (List)this.objectMapper.readValue(responseContent, TypeReferences.STRING_LIST_TYPE);
                    return new SalesforceMultipleChoicesException(reason, statusCode, choices);
                }
                List<RestError> restErrors = null;
                String body = null;
                try {
                    restErrors = this.readErrorsFrom(responseContent, this.objectMapper);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    responseContent.reset();
                    body = IOUtils.toString((InputStream)responseContent, (Charset)StandardCharsets.UTF_8);
                    responseContent.reset();
                }
                catch (Exception t) {
                    this.log.warn("Unable to reset HTTP response content input stream.");
                }
                if (statusCode == 404) {
                    return new NoSuchSObjectException(restErrors);
                }
                return new SalesforceException(restErrors, statusCode, "Unexpected error: " + reason + ". See exception `errors` property for detail. " + body, responseContent);
            }
            catch (IOException | RuntimeException e) {
                String msg = "Unexpected Error parsing error response body + [" + String.valueOf(responseContent) + "] : " + e.getMessage();
                this.log.warn(msg, (Throwable)e);
            }
        }
        return new SalesforceException("Unexpected error: " + reason + ", with content: " + String.valueOf(responseContent), statusCode);
    }

    static Map<String, String> determineHeadersFrom(Response response) {
        HttpFields headers = response.getHeaders();
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (HttpField header : headers) {
            String headerName = header.getName();
            if (!headerName.startsWith("Sforce")) continue;
            answer.put(headerName, header.getValue());
        }
        if (response.getStatus() != 0) {
            answer.put("CamelHttpResponseCode", String.valueOf(response.getStatus()));
            answer.put("CamelHttpResponseText", response.getReason());
        }
        return answer;
    }

    private static void addHeadersTo(Request request, Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        request.headers(requestHeaders -> {
            for (Map.Entry header : headers.entrySet()) {
                requestHeaders.put((String)header.getKey(), (List)header.getValue());
            }
        });
    }

    static Map<String, List<String>> determineHeaders(Exchange exchange) {
        Message inboundMessage = exchange.getIn();
        Map headers = inboundMessage.getHeaders();
        HashMap<String, List<String>> answer = new HashMap<String, List<String>>();
        for (String headerName : headers.keySet()) {
            String headerNameLowercase = headerName.toLowerCase(Locale.US);
            if (!headerNameLowercase.startsWith("sforce") && !headerNameLowercase.startsWith("x-sfdc")) continue;
            Object headerValue = inboundMessage.getHeader(headerName);
            if (headerValue instanceof String) {
                answer.put(headerName, Collections.singletonList((String)headerValue));
                continue;
            }
            if (headerValue instanceof String[]) {
                answer.put(headerName, Arrays.asList((String[])headerValue));
                continue;
            }
            if (headerValue instanceof Collection) {
                answer.put(headerName, ((Collection)headerValue).stream().map(String::valueOf).collect(Collectors.toList()));
                continue;
            }
            throw new IllegalArgumentException("Given value for header `" + headerName + "`, is not String, String array or a Collection");
        }
        return answer;
    }

    protected static interface ClientResponseCallback {
        public void onResponse(InputStream var1, Map<String, String> var2, SalesforceException var3);
    }
}

