/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PlatformEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ZonedDateTime created;
    private final String createdById;
    private final Map<String, String> eventData = new HashMap<String, String>();

    @JsonCreator
    public PlatformEvent(@JsonProperty(value="CreatedDate") ZonedDateTime created, @JsonProperty(value="CreatedById") String createdById) {
        this.created = created;
        this.createdById = createdById;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlatformEvent)) {
            return false;
        }
        PlatformEvent other = (PlatformEvent)obj;
        return Objects.equals(this.created, other.created) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.eventData, other.eventData);
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public Map<String, String> getEventData() {
        return this.eventData;
    }

    public int hashCode() {
        return Objects.hash(this.created, this.createdById, this.eventData);
    }

    @JsonAnySetter
    public void set(String name, String value) {
        this.eventData.put(name, value);
    }

    public String toString() {
        return "PlatformEvent: createdById: " + this.createdById + ", createdId: " + this.created + ", data: " + this.eventData;
    }
}

