/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.processor.AnalyticsApiProcessor;
import org.apache.camel.component.salesforce.internal.processor.BulkApiProcessor;
import org.apache.camel.component.salesforce.internal.processor.BulkApiV2Processor;
import org.apache.camel.component.salesforce.internal.processor.CompositeApiProcessor;
import org.apache.camel.component.salesforce.internal.processor.JsonRestProcessor;
import org.apache.camel.component.salesforce.internal.processor.SalesforceProcessor;
import org.apache.camel.component.salesforce.internal.processor.XmlRestProcessor;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceProducer.class);
    private final SalesforceProcessor processor;

    public SalesforceProducer(SalesforceEndpoint endpoint) throws SalesforceException {
        super((Endpoint)endpoint);
        SalesforceEndpointConfig endpointConfig = endpoint.getConfiguration();
        PayloadFormat payloadFormat = endpointConfig.getFormat();
        OperationName operationName = endpoint.getOperationName();
        this.processor = SalesforceProducer.isBulkOperation(operationName) ? new BulkApiProcessor(endpoint) : (this.isBulkV2Operation(operationName) ? new BulkApiV2Processor(endpoint) : (SalesforceProducer.isAnalyticsOperation(operationName) ? new AnalyticsApiProcessor(endpoint) : (SalesforceProducer.isCompositeOperation(operationName) ? new CompositeApiProcessor(endpoint) : (payloadFormat == PayloadFormat.JSON ? new JsonRestProcessor(endpoint) : new XmlRestProcessor(endpoint)))));
    }

    private boolean isBulkV2Operation(OperationName operationName) {
        switch (operationName) {
            case BULK2_CREATE_JOB: 
            case BULK2_CREATE_BATCH: 
            case BULK2_CLOSE_JOB: 
            case BULK2_GET_JOB: 
            case BULK2_ABORT_JOB: 
            case BULK2_DELETE_JOB: 
            case BULK2_GET_SUCCESSFUL_RESULTS: 
            case BULK2_GET_FAILED_RESULTS: 
            case BULK2_GET_UNPROCESSED_RECORDS: 
            case BULK2_GET_ALL_JOBS: 
            case BULK2_CREATE_QUERY_JOB: 
            case BULK2_GET_QUERY_JOB: 
            case BULK2_GET_QUERY_JOB_RESULTS: 
            case BULK2_ABORT_QUERY_JOB: 
            case BULK2_DELETE_QUERY_JOB: 
            case BULK2_GET_ALL_QUERY_JOBS: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBulkOperation(OperationName operationName) {
        switch (operationName) {
            case CREATE_JOB: 
            case GET_JOB: 
            case CLOSE_JOB: 
            case ABORT_JOB: 
            case CREATE_BATCH: 
            case GET_BATCH: 
            case GET_ALL_BATCHES: 
            case GET_REQUEST: 
            case GET_RESULTS: 
            case CREATE_BATCH_QUERY: 
            case GET_QUERY_RESULT_IDS: 
            case GET_QUERY_RESULT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isAnalyticsOperation(OperationName operationName) {
        switch (operationName) {
            case GET_RECENT_REPORTS: 
            case GET_REPORT_DESCRIPTION: 
            case EXECUTE_SYNCREPORT: 
            case EXECUTE_ASYNCREPORT: 
            case GET_REPORT_INSTANCES: 
            case GET_REPORT_RESULTS: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCompositeOperation(OperationName operationName) {
        switch (operationName) {
            case COMPOSITE_TREE: 
            case COMPOSITE_BATCH: 
            case COMPOSITE: {
                return true;
            }
        }
        return false;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        SalesforceEndpoint endpoint = (SalesforceEndpoint)this.getEndpoint();
        SalesforceSession session = endpoint.getComponent().getSession();
        if (session != null && session.getAccessToken() == null) {
            try {
                session.login(null);
            }
            catch (SalesforceException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)e));
            }
        }
        LOG.debug("Processing {}", (Object)endpoint.getOperationName());
        return this.processor.process(exchange, callback);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
        super.doStop();
    }
}

