/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.codegen.AbstractSalesforceExecution;
import org.apache.camel.component.salesforce.codegen.Defaults;
import org.apache.camel.component.salesforce.codegen.ObjectDescriptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExecution
extends AbstractSalesforceExecution {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaExecution.class.getName());
    String excludePattern;
    String[] excludes;
    String includePattern;
    String[] includes;
    String jsonSchemaFilename;
    String jsonSchemaId;
    File outputDirectory;

    @Override
    protected void executeWithClient() throws Exception {
        this.getLog().info("Generating JSON Schema...");
        ObjectDescriptions descriptions = new ObjectDescriptions(this.getRestClient(), this.getResponseTimeout(), this.includes, this.includePattern, this.excludes, this.excludePattern, this.getLog());
        ObjectMapper schemaObjectMapper = JsonUtils.createSchemaObjectMapper();
        HashSet allSchemas = new HashSet();
        for (SObjectDescription description : descriptions.fetched()) {
            if (Defaults.IGNORED_OBJECTS.contains(description.getName())) continue;
            try {
                allSchemas.addAll(JsonUtils.getSObjectJsonSchema((ObjectMapper)schemaObjectMapper, (SObjectDescription)description, (String)this.jsonSchemaId, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to generate JSON Schema types for: " + description.getName(), e);
            }
        }
        Path schemaFilePath = this.outputDirectory.toPath().resolve(this.jsonSchemaFilename);
        try {
            Files.write(schemaFilePath, JsonUtils.getJsonSchemaString((ObjectMapper)schemaObjectMapper, allSchemas, (String)this.jsonSchemaId).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate JSON Schema source file: " + String.valueOf(schemaFilePath), e);
        }
        this.getLog().info(String.format("Successfully generated %s JSON Types in file %s", descriptions.count() * 2, schemaFilePath));
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setJsonSchemaFilename(String jsonSchemaFilename) {
        this.jsonSchemaFilename = jsonSchemaFilename;
    }

    public void setJsonSchemaId(String jsonSchemaId) {
        this.jsonSchemaId = jsonSchemaId;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

