/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class RocketMQEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topicName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "rocketmq".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "topicName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("accessChannel");
        props.add("accessKey");
        props.add("bridgeErrorHandler");
        props.add("consumerGroup");
        props.add("enableTrace");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("lazyStartProducer");
        props.add("messageSelectorType");
        props.add("namespace");
        props.add("namesrvAddr");
        props.add("producerGroup");
        props.add("replyToConsumerGroup");
        props.add("replyToTopic");
        props.add("requestTimeoutCheckerIntervalMillis");
        props.add("requestTimeoutMillis");
        props.add("secretKey");
        props.add("sendTag");
        props.add("subscribeSql");
        props.add("subscribeTags");
        props.add("topicName");
        props.add("waitForSendResult");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("accessKey");
        secretProps.add("secretKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

