/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq;

import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rocketmq.RocketMQComponent;
import org.apache.camel.component.rocketmq.RocketMQConstants;
import org.apache.camel.component.rocketmq.RocketMQConsumer;
import org.apache.camel.component.rocketmq.RocketMQProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultMessage;

@UriEndpoint(firstVersion="3.20.0", scheme="rocketmq", syntax="rocketmq:topicName", title="RocketMQ", category={Category.MESSAGING}, headersClass=RocketMQConstants.class)
public class RocketMQEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
EndpointServiceLocation {
    @UriPath
    @Metadata(required=true)
    private String topicName;
    @UriParam(label="producer")
    private String producerGroup;
    @UriParam(label="consumer")
    private String consumerGroup;
    @UriParam(label="consumer", defaultValue="*")
    private String subscribeTags = "*";
    @UriParam(label="producer")
    private String sendTag = "";
    @UriParam(label="producer")
    private String replyToTopic;
    @UriParam(label="producer")
    private String replyToConsumerGroup;
    @UriParam(label="common", defaultValue="localhost:9876")
    private String namesrvAddr = "localhost:9876";
    @UriParam(label="advanced", defaultValue="10000")
    private long requestTimeoutMillis = 10000L;
    @UriParam(label="advanced", defaultValue="1000")
    private long requestTimeoutCheckerIntervalMillis = 1000L;
    @UriParam(label="producer", defaultValue="false")
    private boolean waitForSendResult;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;

    public RocketMQEndpoint() {
    }

    public RocketMQEndpoint(String endpointUri, RocketMQComponent component) {
        super(endpointUri, (Component)component);
    }

    public String getServiceUrl() {
        return this.namesrvAddr;
    }

    public String getServiceProtocol() {
        return "rocketmq";
    }

    public Producer createProducer() {
        return new RocketMQProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RocketMQConsumer consumer = new RocketMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createRocketExchange(byte[] body) {
        Exchange exchange = super.createExchange();
        DefaultMessage message = new DefaultMessage(exchange.getContext());
        message.setBody((Object)body);
        exchange.setIn((Message)message);
        return exchange;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSubscribeTags() {
        return this.subscribeTags;
    }

    public void setSubscribeTags(String subscribeTags) {
        this.subscribeTags = subscribeTags;
    }

    public String getSendTag() {
        return this.sendTag;
    }

    public void setSendTag(String sendTag) {
        this.sendTag = sendTag;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getReplyToTopic() {
        return this.replyToTopic;
    }

    public void setReplyToTopic(String replyToTopic) {
        this.replyToTopic = replyToTopic;
    }

    public String getReplyToConsumerGroup() {
        return this.replyToConsumerGroup;
    }

    public void setReplyToConsumerGroup(String replyToConsumerGroup) {
        this.replyToConsumerGroup = replyToConsumerGroup;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
    }

    public long getRequestTimeoutCheckerIntervalMillis() {
        return this.requestTimeoutCheckerIntervalMillis;
    }

    public void setRequestTimeoutCheckerIntervalMillis(long requestTimeoutCheckerIntervalMillis) {
        this.requestTimeoutCheckerIntervalMillis = requestTimeoutCheckerIntervalMillis;
    }

    public boolean isWaitForSendResult() {
        return this.waitForSendResult;
    }

    public void setWaitForSendResult(boolean waitForSendResult) {
        this.waitForSendResult = waitForSendResult;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

