/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.robotframework;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class RobotFrameworkEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":resourceUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "robotframework".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "resourceUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(68);
        props.add("allowContextMapAll");
        props.add("allowTemplateFromHeader");
        props.add("argumentFiles");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("combinedTagStats");
        props.add("criticalTags");
        props.add("debugFile");
        props.add("delay");
        props.add("document");
        props.add("dryrun");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("excludes");
        props.add("exitOnFailure");
        props.add("greedy");
        props.add("includes");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("listener");
        props.add("listeners");
        props.add("log");
        props.add("logLevel");
        props.add("logTitle");
        props.add("metadata");
        props.add("monitorColors");
        props.add("monitorWidth");
        props.add("name");
        props.add("noStatusReturnCode");
        props.add("nonCriticalTags");
        props.add("output");
        props.add("outputDirectory");
        props.add("pollStrategy");
        props.add("randomize");
        props.add("repeatCount");
        props.add("report");
        props.add("reportBackground");
        props.add("reportTitle");
        props.add("resourceUri");
        props.add("runEmptySuite");
        props.add("runFailed");
        props.add("runLoggingLevel");
        props.add("runMode");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("skipTeardownOnExit");
        props.add("splitOutputs");
        props.add("startScheduler");
        props.add("suiteStatLevel");
        props.add("suites");
        props.add("summaryTitle");
        props.add("tagDocs");
        props.add("tagStatExcludes");
        props.add("tagStatIncludes");
        props.add("tagStatLinks");
        props.add("tags");
        props.add("tests");
        props.add("timeUnit");
        props.add("timestampOutputs");
        props.add("useFixedDelay");
        props.add("variableFiles");
        props.add("variables");
        props.add("warnOnSkippedFiles");
        props.add("xunitFile");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

