/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultRestRegistry
extends ServiceSupport
implements RestRegistry,
CamelContextAware {
    private CamelContext camelContext;
    private final Map<Consumer, List<RestRegistry.RestService>> registry = new LinkedHashMap<Consumer, List<RestRegistry.RestService>>();
    private transient Producer apiProducer;

    public void addRestService(Consumer consumer, boolean contractFirst, String url, String baseUrl, String basePath, String uriTemplate, String method, String consumes, String produces, String inType, String outType, String routeId, String description) {
        RestServiceEntry entry = new RestServiceEntry(consumer, contractFirst, url, baseUrl, basePath, uriTemplate, method, consumes, produces, inType, outType, description);
        List list = this.registry.computeIfAbsent(consumer, c -> new ArrayList());
        list.add(entry);
    }

    public void removeRestService(Consumer consumer) {
        this.registry.remove(consumer);
    }

    public List<RestRegistry.RestService> listAllRestServices() {
        ArrayList<RestRegistry.RestService> answer = new ArrayList<RestRegistry.RestService>();
        for (List<RestRegistry.RestService> list : this.registry.values()) {
            answer.addAll(list);
        }
        return answer;
    }

    public int size() {
        int count = 0;
        for (List<RestRegistry.RestService> list : this.registry.values()) {
            count += list.size();
        }
        return count;
    }

    public String apiDocAsJson() {
        if (this.apiProducer == null) {
            RestEndpoint rest;
            String componentName;
            Endpoint restApiEndpoint = null;
            Endpoint restEndpoint = null;
            for (Map.Entry entry : this.camelContext.getEndpointRegistry().entrySet()) {
                String uri = ((NormalizedEndpointUri)entry.getKey()).getUri();
                if (uri.startsWith("rest-api:")) {
                    restApiEndpoint = (Endpoint)entry.getValue();
                    break;
                }
                if (restEndpoint != null || !uri.startsWith("rest:")) continue;
                restEndpoint = (Endpoint)entry.getValue();
            }
            if (restApiEndpoint == null && restEndpoint != null && (componentName = (rest = (RestEndpoint)restEndpoint).getProducerComponentName()) != null) {
                RestConfiguration config = this.camelContext.getRestConfiguration();
                String apiComponent = config.getApiComponent() != null ? config.getApiComponent() : "openapi";
                String path = config.getApiContextPath() != null ? config.getApiContextPath() : "api-doc";
                String uri = String.format("rest-api:%s/%s?componentName=%s&apiComponentName=%s", path, this.camelContext.getName(), componentName, apiComponent);
                restApiEndpoint = this.camelContext.getEndpoint(uri);
            }
            if (restApiEndpoint != null) {
                try {
                    this.apiProducer = restApiEndpoint.createProducer();
                    this.camelContext.addService((Object)this.apiProducer, true);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        if (this.apiProducer != null) {
            try {
                Exchange dummy = this.apiProducer.getEndpoint().createExchange();
                this.apiProducer.process(dummy);
                return (String)dummy.getMessage().getBody(String.class);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        this.camelContext.addLifecycleStrategy((LifecycleStrategy)new RemoveRestServiceLifecycleStrategy());
    }

    protected void doStop() throws Exception {
        this.registry.clear();
    }

    private static final class RestServiceEntry
    implements RestRegistry.RestService {
        private final Consumer consumer;
        private final boolean contractFirst;
        private final String url;
        private final String baseUrl;
        private final String basePath;
        private final String uriTemplate;
        private final String method;
        private final String consumes;
        private final String produces;
        private final String inType;
        private final String outType;
        private final String description;

        private RestServiceEntry(Consumer consumer, boolean contractFirst, String url, String baseUrl, String basePath, String uriTemplate, String method, String consumes, String produces, String inType, String outType, String description) {
            this.consumer = consumer;
            this.contractFirst = contractFirst;
            this.url = url;
            this.baseUrl = baseUrl;
            this.basePath = basePath;
            this.uriTemplate = uriTemplate;
            this.method = method;
            this.consumes = consumes;
            this.produces = produces;
            this.inType = inType;
            this.outType = outType;
            this.description = description;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public boolean isContractFirst() {
            return this.contractFirst;
        }

        public String getUrl() {
            return this.url;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public String getUriTemplate() {
            return this.uriTemplate;
        }

        public String getMethod() {
            return this.method;
        }

        public String getConsumes() {
            return this.consumes;
        }

        public String getProduces() {
            return this.produces;
        }

        public String getInType() {
            return this.inType;
        }

        public String getOutType() {
            return this.outType;
        }

        public String getState() {
            ServiceStatus status = null;
            Consumer consumer = this.consumer;
            if (consumer instanceof StatefulService) {
                StatefulService statefulService = (StatefulService)consumer;
                status = statefulService.getStatus();
            }
            if (status == null) {
                status = ServiceStatus.Stopped;
            }
            return status.name();
        }

        public String getDescription() {
            return this.description;
        }
    }

    private final class RemoveRestServiceLifecycleStrategy
    extends LifecycleStrategySupport {
        private RemoveRestServiceLifecycleStrategy() {
        }

        public void onServiceRemove(CamelContext context, Service service, Route route) {
            super.onServiceRemove(context, service, route);
            if (service instanceof Consumer) {
                Consumer consumer = (Consumer)service;
                DefaultRestRegistry.this.removeRestService(consumer);
            }
        }
    }
}

