/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.component.rest.RestProducerBindingProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class RestProducer
extends DefaultAsyncProducer {
    private static final String ACCEPT = "Accept";
    private final CamelContext camelContext;
    private final RestConfiguration configuration;
    private boolean prepareUriTemplate = true;
    private RestConfiguration.RestBindingMode bindingMode;
    private Boolean skipBindingOnErrorCode;
    private String type;
    private String outType;
    private AsyncProcessor producer;
    private AsyncProcessor binding;

    public RestProducer(Endpoint endpoint, Producer producer, RestConfiguration configuration) {
        super(endpoint);
        this.camelContext = endpoint.getCamelContext();
        this.configuration = configuration;
        this.producer = AsyncProcessorConverterHelper.convert((Producer)producer);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.prepareExchange(exchange);
            if (this.binding != null) {
                return this.binding.process(exchange, callback);
            }
            return this.producer.process(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    public RestEndpoint getEndpoint() {
        return (RestEndpoint)super.getEndpoint();
    }

    public boolean isPrepareUriTemplate() {
        return this.prepareUriTemplate;
    }

    public void setPrepareUriTemplate(boolean prepareUriTemplate) {
        this.prepareUriTemplate = prepareUriTemplate;
    }

    public RestConfiguration.RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestConfiguration.RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    protected void prepareExchange(Exchange exchange) throws Exception {
        String method;
        String query;
        boolean hasPath = false;
        String resolvedUriTemplate = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getUriTemplate() : this.getEndpoint().getPath();
        Message inMessage = exchange.getIn();
        if (this.prepareUriTemplate && resolvedUriTemplate.contains("{")) {
            String[] arr = resolvedUriTemplate.split("\\/");
            CollectionStringBuffer csb = new CollectionStringBuffer("/");
            for (String a : arr) {
                if (a.startsWith("{") && a.endsWith("}")) {
                    String key = a.substring(1, a.length() - 1);
                    String value = (String)inMessage.getHeader(key, String.class);
                    if (value != null) {
                        hasPath = true;
                        csb.append((Object)value);
                        continue;
                    }
                    csb.append((Object)a);
                    continue;
                }
                csb.append((Object)a);
            }
            resolvedUriTemplate = csb.toString();
        }
        if ((query = RestProducer.createQueryParameters(this.getEndpoint().getQueryParameters(), inMessage)) != null) {
            inMessage.setHeader("CamelRestHttpQuery", (Object)query);
        }
        if (hasPath) {
            String host = this.getEndpoint().getHost();
            String basePath = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getPath() : null;
            basePath = FileUtil.stripLeadingSeparator((String)basePath);
            resolvedUriTemplate = FileUtil.stripLeadingSeparator((String)resolvedUriTemplate);
            String overrideUri = host;
            if (!ObjectHelper.isEmpty((Object)basePath)) {
                overrideUri = overrideUri + "/" + basePath;
            }
            if (!ObjectHelper.isEmpty((Object)resolvedUriTemplate)) {
                overrideUri = overrideUri + "/" + resolvedUriTemplate;
            }
            inMessage.setHeader("CamelRestHttpUri", (Object)overrideUri);
            inMessage.removeHeader("CamelHttpPath");
        }
        if ((method = this.getEndpoint().getMethod()) != null) {
            String upper = method.toUpperCase(Locale.US);
            inMessage.setHeader("CamelHttpMethod", (Object)upper);
        }
        String produces = this.getEndpoint().getProduces();
        if (ObjectHelper.isEmpty((Object)inMessage.getHeader("Content-Type")) && ObjectHelper.isNotEmpty((Object)produces)) {
            inMessage.setHeader("Content-Type", (Object)produces);
        }
        String consumes = this.getEndpoint().getConsumes();
        if (ObjectHelper.isEmpty((Object)inMessage.getHeader(ACCEPT)) && ObjectHelper.isNotEmpty((Object)consumes)) {
            inMessage.setHeader(ACCEPT, (Object)consumes);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.binding = this.createBindingProcessor();
        ServiceHelper.startService((Object[])new Object[]{this.binding, this.producer});
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object[])new Object[]{this.producer, this.binding});
    }

    protected AsyncProcessor createBindingProcessor() throws Exception {
        String mode = this.configuration.getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode.name();
        }
        boolean skip = this.configuration.isSkipBindingOnErrorCode();
        if (this.skipBindingOnErrorCode != null) {
            skip = this.skipBindingOnErrorCode;
        }
        if (mode == null || "off".equals(mode)) {
            return null;
        }
        String name = this.configuration.getJsonDataFormat();
        if (name != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "json-jackson";
        }
        DataFormat json = this.camelContext.resolveDataFormat(name);
        DataFormat outJson = this.camelContext.resolveDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSon DataFormat " + name + " not found.");
        }
        if (json != null) {
            Class clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)json, (String)"unmarshalType", clazz);
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)json, (String)"useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, json, "json.in.");
            Class outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)outJson, (String)"unmarshalType", outClazz);
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)outJson, (String)"useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, outJson, "json.out.");
        }
        if ((name = this.configuration.getXmlDataFormat()) != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "jaxb";
        }
        DataFormat jaxb = this.camelContext.resolveDataFormat(name);
        DataFormat outJaxb = this.camelContext.resolveDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            JAXBContext jc;
            Class clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)jaxb, (String)"context", (Object)jc2);
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, jaxb, "xml.in.");
            Class outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)outJaxb, (String)"context", (Object)jc);
            } else if (clazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty((TypeConverter)this.camelContext.getTypeConverter(), (Object)outJaxb, (String)"context", (Object)jc);
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, outJaxb, "xml.out.");
        }
        return new RestProducerBindingProcessor(this.producer, this.camelContext, json, jaxb, outJson, outJaxb, mode, skip, this.outType);
    }

    private void setAdditionalConfiguration(RestConfiguration config, CamelContext context, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            EndpointHelper.setReferenceProperties((CamelContext)context, (Object)dataFormat, copy);
            EndpointHelper.setProperties((CamelContext)context, (Object)dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    static String createQueryParameters(String query, Message inMessage) throws URISyntaxException, UnsupportedEncodingException {
        if (query != null) {
            Map givenParams = URISupport.parseQuery((String)query);
            LinkedHashMap params = new LinkedHashMap(givenParams.size());
            for (Map.Entry entry : givenParams.entrySet()) {
                Object v = entry.getValue();
                if (v == null) continue;
                String a = v.toString();
                if ((a = URLDecoder.decode(a, "UTF-8")).startsWith("{") && a.endsWith("}")) {
                    String value;
                    String key = a.substring(1, a.length() - 1);
                    boolean optional = false;
                    if (key.endsWith("?")) {
                        key = key.substring(0, key.length() - 1);
                        optional = true;
                    }
                    if ((value = (String)inMessage.getHeader(key, String.class)) != null) {
                        params.put(entry.getKey(), value);
                        continue;
                    }
                    if (optional) continue;
                    params.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                params.put(entry.getKey(), (String)entry.getValue());
            }
            query = URISupport.createQueryString(params);
        }
        return query;
    }
}

