/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.rest.openapi.DefaultRestOpenapiProcessorStrategy;
import org.apache.camel.component.rest.openapi.RestOpenApiEndpoint;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

@Component(value="rest-openapi")
public final class RestOpenApiComponent
extends DefaultComponent
implements SSLContextParametersAware {
    public static final String DEFAULT_BASE_PATH = "/";
    static final String DEFAULT_SPECIFICATION_URI = "openapi.json";
    @Metadata(description="Path to the OpenApi specification file. The scheme, host base path are taken from this specification, but these can be overridden with properties on the component or endpoint level. If not given the component tries to load `openapi.json` resource. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `https://api.example.com:8080`). Can be overridden in endpoint configuration.", label="common")
    private String specificationUri;
    @Metadata(description="API basePath, for example \"`/v2`\". Default is unset, if set overrides the value present in OpenApi specification.", label="common")
    private String basePath = "";
    @Metadata(description="Name of the Camel component that will perform the requests. The component must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Can be overridden in endpoint configuration.", label="producer,advanced")
    private String componentName;
    @Metadata(description="Name of the Camel component that will service the requests. The component must be present in Camel registry and it must implement RestOpenApiConsumerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestOpenApiConsumerFactory SPI.  Can be overridden in endpoint configuration.", label="consumer,advanced")
    private String consumerComponentName;
    @Metadata(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the corresponding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-openapi` next, and global configuration last. If set overrides any value found in the OpenApi specification, RestConfiguration. Can be overridden in endpoint configuration.", label="producer")
    private String host;
    @Metadata(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the OpenApi specification. Can be overridden in endpoint configuration", label="producer,advanced")
    private String consumes;
    @Metadata(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the OpenApi specification. Can be overridden in endpoint configuration.", label="producer,advanced")
    private String produces;
    @Metadata(label="consumer,advanced", description="Package name to use as base (offset) for classpath scanning of POJO classes are located when using binding mode is enabled for JSon or XML. Multiple package names can be separated by comma.")
    private String bindingPackageScan;
    @Metadata(label="consumer", description="Whether to enable validation of the client request to check if the incoming request is valid according to the OpenAPI specification")
    private boolean clientRequestValidation;
    @Metadata(label="consumer", description="Whether to enable validation of the client request to check if the outgoing response from Camel is valid according to the OpenAPI specification")
    private boolean clientResponseValidation;
    @Metadata(label="producer", description="Enable validation of requests against the configured OpenAPI specification")
    private boolean requestValidationEnabled;
    @Metadata(description="Whether the consumer should fail,ignore or return a mock response for OpenAPI operations that are not mapped to a corresponding route.", label="consumer", enums="fail,ignore,mock", defaultValue="fail")
    private String missingOperation;
    @Metadata(description="Used for inclusive filtering of mock data from directories. The pattern is using Ant-path style pattern. Multiple patterns can be specified separated by comma.", label="consumer,advanced", defaultValue="classpath:camel-mock/**")
    private String mockIncludePattern = "classpath:camel-mock/**";
    @Metadata(label="consumer", description="Sets the context-path to use for servicing the OpenAPI specification")
    private String apiContextPath;
    @Metadata(description="To use a custom strategy for how to process Rest DSL requests", label="consumer,advanced")
    private RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    @Metadata(description="Enable usage of global SSL context parameters.", label="security")
    private boolean useGlobalSslContextParameters;
    @Metadata(description="Customize TLS parameters used by the component. If not set defaults to the TLS parameters set in the Camel context ", label="security")
    private SSLContextParameters sslContextParameters;

    public RestOpenApiComponent() {
    }

    public RestOpenApiComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RestOpenApiEndpoint endpoint = new RestOpenApiEndpoint(uri, remaining, this, parameters);
        endpoint.setApiContextPath(this.getApiContextPath());
        endpoint.setBasePath(this.getBasePath());
        endpoint.setBindingPackageScan(this.getBindingPackageScan());
        endpoint.setClientRequestValidation(this.isClientRequestValidation());
        endpoint.setClientResponseValidation(this.isClientResponseValidation());
        endpoint.setComponentName(this.getComponentName());
        endpoint.setConsumerComponentName(this.getConsumerComponentName());
        endpoint.setConsumes(this.getConsumes());
        if (this.getHost() != null) {
            endpoint.setHost(this.getHost());
        }
        endpoint.setProduces(this.getProduces());
        endpoint.setRequestValidationEnabled(this.isRequestValidationEnabled());
        if (this.getSpecificationUri() != null) {
            endpoint.setSpecificationUri(this.getSpecificationUri());
        }
        endpoint.setMissingOperation(this.getMissingOperation());
        endpoint.setMockIncludePattern(this.getMockIncludePattern());
        endpoint.setRestOpenapiProcessorStrategy(this.getRestOpenapiProcessorStrategy());
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.bindingPackageScan == null) {
            String base = this.getCamelContext().getRestConfiguration().getBindingPackageScan();
            if (base == null) {
                base = this.getCamelContext().getCamelContextExtension().getBasePackageScan();
            }
            this.bindingPackageScan = base;
        }
        if (this.restOpenapiProcessorStrategy == null) {
            this.restOpenapiProcessorStrategy = new DefaultRestOpenapiProcessorStrategy();
            CamelContextAware.trySetCamelContext((Object)this.restOpenapiProcessorStrategy, (CamelContext)this.getCamelContext());
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumerComponentName() {
        return this.consumerComponentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getProduces() {
        return this.produces;
    }

    public String getSpecificationUri() {
        return this.specificationUri;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public RestOpenapiProcessorStrategy getRestOpenapiProcessorStrategy() {
        return this.restOpenapiProcessorStrategy;
    }

    public void setRestOpenapiProcessorStrategy(RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public String getMissingOperation() {
        return this.missingOperation;
    }

    public void setMissingOperation(String missingOperation) {
        this.missingOperation = missingOperation;
    }

    public String getMockIncludePattern() {
        return this.mockIncludePattern;
    }

    public void setMockIncludePattern(String mockIncludePattern) {
        this.mockIncludePattern = mockIncludePattern;
    }

    public String getApiContextPath() {
        return this.apiContextPath;
    }

    public void setApiContextPath(String apiContextPath) {
        this.apiContextPath = apiContextPath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public void setConsumes(String consumes) {
        this.consumes = RestOpenApiHelper.isMediaRange(consumes, "consumes");
    }

    public void setHost(String host) {
        this.host = RestOpenApiHelper.isHostParam(host);
    }

    public void setProduces(String produces) {
        this.produces = RestOpenApiHelper.isMediaRange(produces, "produces");
    }

    public void setSpecificationUri(String specificationUri) {
        this.specificationUri = specificationUri;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public void setRequestValidationEnabled(boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    public boolean isRequestValidationEnabled() {
        return this.requestValidationEnabled;
    }

    public boolean isClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(boolean clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public boolean isClientResponseValidation() {
        return this.clientResponseValidation;
    }

    public void setClientResponseValidation(boolean clientResponseValidation) {
        this.clientResponseValidation = clientResponseValidation;
    }

    public String getBindingPackageScan() {
        return this.bindingPackageScan;
    }

    public void setBindingPackageScan(String bindingPackageScan) {
        this.bindingPackageScan = bindingPackageScan;
    }
}

