/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.maven.htmlxlsx.model.ChildEip;

public class EipAttribute
implements Comparable<EipAttribute> {
    @JsonIgnore
    private static ObjectMapper OBJECT_MAPPER;
    private String id;
    private int exchangesTotal;
    private int index;
    private int totalProcessingTime;
    private Properties properties = new Properties();
    private Map<String, List<ChildEip>> childEipMap = new LinkedHashMap<String, List<ChildEip>>();

    protected ObjectMapper objectMapper() {
        if (OBJECT_MAPPER == null) {
            OBJECT_MAPPER = new ObjectMapper();
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OBJECT_MAPPER.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        }
        return OBJECT_MAPPER;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getExchangesTotal() {
        return this.exchangesTotal;
    }

    public void setExchangesTotal(int exchangesTotal) {
        this.exchangesTotal = exchangesTotal;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public void setTotalProcessingTime(int totalProcessingTime) {
        this.totalProcessingTime = totalProcessingTime;
    }

    @JsonAnySetter
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
        if (value instanceof Map) {
            try {
                String childJson = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value);
                ChildEip childEip = (ChildEip)this.objectMapper().readValue(childJson, ChildEip.class);
                if (childEip.getId() == null) {
                    childEip.setId(this.id + "-" + this.childEipMap.size());
                }
                this.childEipMap.put(key, Collections.singletonList(childEip));
                this.properties.remove(key);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof List) {
            try {
                String childJson = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value);
                CollectionType javaType = this.objectMapper().getTypeFactory().constructCollectionType(List.class, ChildEip.class);
                List childEipList = (List)this.objectMapper().readValue(childJson, (JavaType)javaType);
                this.childEipMap.put(key, childEipList);
                this.properties.remove(key);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @JsonAnyGetter
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, List<ChildEip>> getChildEipMap() {
        return this.childEipMap;
    }

    public void setChildEipMap(Map<String, List<ChildEip>> childEipMap) {
        this.childEipMap = childEipMap;
    }

    @Override
    public int compareTo(EipAttribute o) {
        if (o == null) {
            return 1;
        }
        return this.index - o.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EipAttribute)) {
            return false;
        }
        return this.id.equals(((EipAttribute)o).id);
    }

    public String toString() {
        return "EipAttribute{id='" + this.id + "', exchangesTotal=" + this.exchangesTotal + ", index=" + this.index + ", totalProcessingTime=" + this.totalProcessingTime + ", properties=" + String.valueOf(this.properties) + ", childEipMap=" + String.valueOf(this.childEipMap) + "}";
    }
}

