/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.Set;
import org.apache.camel.support.PatternHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

final class ReportPluginCommon {
    private ReportPluginCommon() {
    }

    public static String asRelativeFile(String name, MavenProject project) {
        String answer = name;
        String base = project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    public static String stripRootPath(String name, MavenProject project) {
        String dir;
        for (String dir2 : project.getCompileSourceRoots()) {
            if (!name.startsWith(dir2 = ReportPluginCommon.asRelativeFile(dir2, project))) continue;
            return name.substring(dir2.length() + 1);
        }
        for (String dir2 : project.getTestCompileSourceRoots()) {
            if (!name.startsWith(dir2 = ReportPluginCommon.asRelativeFile(dir2, project))) continue;
            return name.substring(dir2.length() + 1);
        }
        for (Resource resource : project.getResources()) {
            dir = ReportPluginCommon.asRelativeFile(resource.getDirectory(), project);
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        for (Resource resource : project.getTestResources()) {
            dir = ReportPluginCommon.asRelativeFile(resource.getDirectory(), project);
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return name;
    }

    public static boolean fileListMatchesPattern(String fileList, File file, MavenProject project) {
        for (String exclude : fileList.split(",")) {
            boolean match;
            exclude = exclude.trim();
            String fqn = ReportPluginCommon.stripRootPath(ReportPluginCommon.asRelativeFile(file.getAbsolutePath(), project), project);
            boolean bl = match = PatternHelper.matchPattern((String)fqn, (String)exclude) || PatternHelper.matchPattern((String)file.getName(), (String)exclude);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static void findXmlFiles(File dir, Set<File> xmlFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".xml")) {
                    xmlFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ReportPluginCommon.findXmlFiles(file, xmlFiles);
            }
        }
    }

    public static void findJavaFiles(File dir, Set<File> javaFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".java")) {
                    javaFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ReportPluginCommon.findJavaFiles(file, javaFiles);
            }
        }
    }

    public static boolean matchRouteFile(File file, String excludes, String includes, MavenProject project) {
        if (excludes == null && includes == null) {
            return true;
        }
        if (excludes != null && ReportPluginCommon.fileListMatchesPattern(excludes, file, project)) {
            return false;
        }
        if (includes != null) {
            return ReportPluginCommon.fileListMatchesPattern(includes, file, project);
        }
        return true;
    }

    public static void findJavaRouteBuilderClasses(Set<File> javaFiles, boolean includeJava, boolean includeTest, MavenProject project) {
        if (includeJava) {
            for (String dir : project.getCompileSourceRoots()) {
                ReportPluginCommon.findJavaFiles(new File(dir), javaFiles);
            }
            if (includeTest) {
                for (String dir : project.getTestCompileSourceRoots()) {
                    ReportPluginCommon.findJavaFiles(new File(dir), javaFiles);
                }
            }
        }
    }

    public static void findXmlRouters(Set<File> xmlFiles, boolean includeXml, boolean includeTest, MavenProject project) {
        if (includeXml) {
            for (Resource dir : project.getResources()) {
                ReportPluginCommon.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
            if (includeTest) {
                for (Resource dir : project.getTestResources()) {
                    ReportPluginCommon.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
                }
            }
        }
    }
}

