/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsCamelSubscriber
implements Subscriber<Exchange>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStreamsCamelSubscriber.class);
    private static final long UNBOUNDED_REQUESTS = Long.MAX_VALUE;
    private final Lock lock = new ReentrantLock();
    private final String name;
    private ReactiveStreamsConsumer consumer;
    private Subscription subscription;
    private long requested;
    private long inflightCount;

    public ReactiveStreamsCamelSubscriber(String name) {
        this.name = name;
    }

    public void attachConsumer(ReactiveStreamsConsumer consumer) {
        this.lock.lock();
        try {
            if (this.consumer != null) {
                throw new IllegalStateException("A consumer is already attached to the stream '" + this.name + "'");
            }
            this.consumer = consumer;
        }
        finally {
            this.lock.unlock();
        }
        this.refill();
    }

    public ReactiveStreamsConsumer getConsumer() {
        this.lock.lock();
        try {
            ReactiveStreamsConsumer reactiveStreamsConsumer = this.consumer;
            return reactiveStreamsConsumer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void detachConsumer() {
        this.lock.lock();
        try {
            this.consumer = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null for stream '" + this.name + "'");
        }
        boolean allowed = true;
        this.lock.lock();
        try {
            if (this.subscription != null) {
                allowed = false;
            } else {
                this.subscription = subscription;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!allowed) {
            LOG.warn("There is another active subscription: cancelled");
            subscription.cancel();
        } else {
            this.refill();
        }
    }

    public void onNext(Exchange exchange) {
        ReactiveStreamsConsumer target;
        if (exchange == null) {
            throw new NullPointerException("exchange is null");
        }
        this.lock.lock();
        try {
            if (this.requested < Long.MAX_VALUE) {
                --this.requested;
            }
            if ((target = this.consumer) != null) {
                ++this.inflightCount;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (target != null) {
            target.process(exchange, doneSync -> {
                this.lock.lock();
                try {
                    --this.inflightCount;
                }
                finally {
                    this.lock.unlock();
                }
                this.refill();
            });
        } else {
            LOG.warn("Message received in stream '{}', but no consumers were attached. Discarding {}.", (Object)this.name, (Object)exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refill() {
        Long toBeRequested = null;
        Subscription subs = null;
        this.lock.lock();
        try {
            if (this.consumer != null && this.subscription != null) {
                long max;
                Integer consMax = this.consumer.getEndpoint().getMaxInflightExchanges();
                long l = max = consMax != null && consMax > 0 ? consMax.longValue() : Long.MAX_VALUE;
                if (this.requested < Long.MAX_VALUE) {
                    long lowWatermark = Math.max(0L, Math.round(this.consumer.getEndpoint().getExchangesRefillLowWatermark() * (double)max));
                    long minRequests = Math.min(max, max - lowWatermark);
                    long newRequest = max - this.requested - this.inflightCount;
                    if (newRequest > 0L && newRequest >= minRequests) {
                        toBeRequested = newRequest;
                        this.requested += toBeRequested.longValue();
                        subs = this.subscription;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (toBeRequested != null) {
            subs.request(toBeRequested.longValue());
        }
    }

    public void onError(Throwable throwable) {
        ReactiveStreamsConsumer consumer;
        if (throwable == null) {
            throw new NullPointerException("throwable is null");
        }
        LOG.error("Error in reactive stream '{}'", (Object)this.name, (Object)throwable);
        this.lock.lock();
        try {
            consumer = this.consumer;
            this.subscription = null;
        }
        finally {
            this.lock.unlock();
        }
        if (consumer != null) {
            consumer.onError(throwable);
        }
    }

    public void onComplete() {
        ReactiveStreamsConsumer consumer;
        LOG.info("Reactive stream '{}' completed", (Object)this.name);
        this.lock.lock();
        try {
            consumer = this.consumer;
            this.subscription = null;
        }
        finally {
            this.lock.unlock();
        }
        if (consumer != null) {
            consumer.onComplete();
        }
    }

    @Override
    public void close() throws IOException {
        Subscription subscription;
        this.lock.lock();
        try {
            subscription = this.subscription;
        }
        finally {
            this.lock.unlock();
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public long getRequested() {
        return this.requested;
    }

    public long getInflightCount() {
        return this.inflightCount;
    }
}

