/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Service;
import org.apache.camel.component.quickfixj.QuickfixjComponent;
import org.apache.camel.component.quickfixj.QuickfixjConsumer;
import org.apache.camel.component.quickfixj.QuickfixjEngine;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.apache.camel.component.quickfixj.QuickfixjEventListener;
import org.apache.camel.component.quickfixj.QuickfixjProducer;
import org.apache.camel.component.quickfixj.converter.QuickfixjConverters;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Message;
import quickfix.SessionID;

@UriEndpoint(firstVersion="2.1.0", scheme="quickfix", title="QuickFix", syntax="quickfix:configurationName", category={Category.MESSAGING}, headersClass=QuickfixjEndpoint.class)
public class QuickfixjEndpoint
extends DefaultEndpoint
implements QuickfixjEventListener,
MultipleConsumersSupport {
    @Metadata(description="The event category.", javaType="org.apache.camel.component.quickfixj.QuickfixjEventCategory")
    public static final String EVENT_CATEGORY_KEY = "EventCategory";
    @Metadata(description="The FIX message SessionID.", javaType="quickfix.SessionID")
    public static final String SESSION_ID_KEY = "SessionID";
    @Metadata(description="The FIX MsgType tag value.", javaType="String")
    public static final String MESSAGE_TYPE_KEY = "MessageType";
    public static final String DATA_DICTIONARY_KEY = "DataDictionary";
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjEndpoint.class);
    private final QuickfixjEngine engine;
    private final Lock engineLock = new ReentrantLock();
    private final List<QuickfixjConsumer> consumers = new CopyOnWriteArrayList<QuickfixjConsumer>();
    @UriPath
    @Metadata(required=true, supportFileReference=true)
    private String configurationName;
    @UriParam
    private String sessionID;
    private volatile SessionID sid;
    @UriParam
    private boolean lazyCreateEngine;

    public QuickfixjEndpoint(QuickfixjEngine engine, String uri, Component component) {
        super(uri, component);
        this.engine = engine;
    }

    public QuickfixjComponent getComponent() {
        return (QuickfixjComponent)super.getComponent();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public SessionID getSID() {
        return this.sid;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
        this.sid = new SessionID(sessionID);
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public boolean isLazyCreateEngine() {
        return this.lazyCreateEngine;
    }

    public void setLazyCreateEngine(boolean lazyCreateEngine) {
        this.lazyCreateEngine = lazyCreateEngine;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.info("Creating QuickFIX/J consumer: {}, ExchangePattern={}", (Object)(this.sessionID != null ? this.sessionID : "No Session"), (Object)this.getExchangePattern());
        QuickfixjConsumer consumer = new QuickfixjConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        LOG.info("Creating QuickFIX/J producer: {}", (Object)(this.sessionID != null ? this.sessionID : "No Session"));
        if (this.isWildcarded()) {
            throw new ResolveEndpointFailedException("Cannot create consumer on wildcarded session identifier: " + this.sessionID);
        }
        return new QuickfixjProducer((Endpoint)this);
    }

    protected void addConsumer(QuickfixjConsumer consumer) {
        this.consumers.add(consumer);
        this.engine.incRefCount();
        this.getComponent().ensureEngineStarted(this.engine);
    }

    protected void removeConsumer(QuickfixjConsumer consumer) {
        this.consumers.remove((Object)consumer);
        int count = this.engine.decRefCount();
        if (count <= 0 && this.getComponent().isEagerStopEngines()) {
            LOG.info("Stopping QuickFIX/J Engine: {} no longer active in use", (Object)this.engine.getUri());
            ServiceHelper.stopService((Service)this.engine);
        }
    }

    protected void addProducer() {
        this.engine.incRefCount();
        this.getComponent().ensureEngineStarted(this.engine);
    }

    protected void removeProducer() {
        int count = this.engine.decRefCount();
        if (count <= 0 && this.getComponent().isEagerStopEngines()) {
            LOG.info("Stopping QuickFIX/J Engine: {} no longer active in use", (Object)this.engine.getUri());
            ServiceHelper.stopService((Service)this.engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(QuickfixjEventCategory eventCategory, SessionID sessionID, Message message) throws Exception {
        if (this.sessionID == null || this.isMatching(sessionID)) {
            for (QuickfixjConsumer consumer : this.consumers) {
                Exchange exchange = QuickfixjConverters.toExchange((Consumer)consumer, sessionID, message, eventCategory, this.getExchangePattern());
                try {
                    consumer.onExchange(exchange);
                    Exception cause = exchange.getException();
                    if (cause == null) continue;
                    throw cause;
                }
                finally {
                    consumer.releaseExchange(exchange, false);
                }
            }
        }
    }

    private boolean isMatching(SessionID sessionID) {
        if (this.sid.equals((Object)sessionID)) {
            return true;
        }
        return this.isMatching(this.sid.getBeginString(), sessionID.getBeginString()) && this.isMatching(this.sid.getSenderCompID(), sessionID.getSenderCompID()) && this.isMatching(this.sid.getSenderSubID(), sessionID.getSenderSubID()) && this.isMatching(this.sid.getSenderLocationID(), sessionID.getSenderLocationID()) && this.isMatching(this.sid.getTargetCompID(), sessionID.getTargetCompID()) && this.isMatching(this.sid.getTargetSubID(), sessionID.getTargetSubID()) && this.isMatching(this.sid.getTargetLocationID(), sessionID.getTargetLocationID());
    }

    private boolean isMatching(String s1, String s2) {
        return s1.isEmpty() || s1.equals("*") || s1.equals(s2);
    }

    private boolean isWildcarded() {
        if (this.sid == null) {
            return false;
        }
        return this.sid.getBeginString().equals("*") || this.sid.getSenderCompID().equals("*") || this.sid.getSenderSubID().equals("*") || this.sid.getSenderLocationID().equals("*") || this.sid.getTargetCompID().equals("*") || this.sid.getTargetSubID().equals("*") || this.sid.getTargetLocationID().equals("*");
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public void ensureInitialized() throws Exception {
        if (!this.engine.isInitialized()) {
            this.engineLock.lock();
            try {
                if (!this.engine.isInitialized()) {
                    this.engine.initializeEngine();
                    ServiceHelper.startService((Service)this.engine);
                }
            }
            finally {
                this.engineLock.unlock();
            }
        }
    }

    public QuickfixjEngine getEngine() {
        return this.engine;
    }

    protected void doStop() throws Exception {
        this.consumers.clear();
    }
}

