/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz2;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz2.ScheduledRoutePolicyConstants;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class SimpleScheduledRoutePolicy
extends ScheduledRoutePolicy {
    private Date routeStartDate;
    private int routeStartRepeatCount;
    private long routeStartRepeatInterval;
    private Date routeStopDate;
    private int routeStopRepeatCount;
    private long routeStopRepeatInterval;
    private Date routeSuspendDate;
    private int routeSuspendRepeatCount;
    private long routeSuspendRepeatInterval;
    private Date routeResumeDate;
    private int routeResumeRepeatCount;
    private long routeResumeRepeatInterval;

    public void onInit(Route route) {
        try {
            this.doOnInit(route);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doOnInit(Route route) throws Exception {
        QuartzComponent quartz = (QuartzComponent)route.getRouteContext().getCamelContext().getComponent("quartz2", QuartzComponent.class);
        this.setScheduler(quartz.getScheduler());
        if (this.getRouteStopGracePeriod() == 0) {
            this.setRouteStopGracePeriod(10000);
        }
        if (this.getTimeUnit() == null) {
            this.setTimeUnit(TimeUnit.MILLISECONDS);
        }
        if (this.getRouteStartDate() == null && this.getRouteStopDate() == null && this.getRouteSuspendDate() == null && this.getRouteResumeDate() == null) {
            throw new IllegalArgumentException("Scheduled Route Policy for route " + route.getId() + " has no start/stop/suspend/resume times specified");
        }
        this.registerRouteToScheduledRouteDetails(route);
        if (this.getRouteStartDate() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START, route);
        }
        if (this.getRouteStopDate() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP, route);
        }
        if (this.getRouteSuspendDate() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND, route);
        }
        if (this.getRouteResumeDate() != null) {
            this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME, route);
        }
    }

    @Override
    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        SimpleTrigger trigger = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_START + route.getId(), "triggerGroup-" + route.getId()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(this.getRouteStartRepeatCount()).withIntervalInMilliseconds(this.getRouteStartRepeatInterval())).startAt(this.routeStartDate == null ? new Date() : this.routeStartDate).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_STOP + route.getId(), "triggerGroup-" + route.getId()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(this.getRouteStopRepeatCount()).withIntervalInMilliseconds(this.getRouteStopRepeatInterval())).startAt(this.routeStopDate == null ? new Date() : this.routeStopDate).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_SUSPEND + route.getId(), "triggerGroup-" + route.getId()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(this.getRouteSuspendRepeatCount()).withIntervalInMilliseconds(this.getRouteSuspendRepeatInterval())).startAt(this.routeSuspendDate == null ? new Date() : this.routeSuspendDate).build();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_RESUME + route.getId(), "triggerGroup-" + route.getId()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(this.getRouteResumeRepeatCount()).withIntervalInMilliseconds(this.getRouteResumeRepeatInterval())).startAt(this.routeResumeDate == null ? new Date() : this.routeResumeDate).build();
        }
        return trigger;
    }

    public Date getRouteStartDate() {
        return this.routeStartDate;
    }

    public void setRouteStartDate(Date routeStartDate) {
        this.routeStartDate = routeStartDate;
    }

    public Date getRouteStopDate() {
        return this.routeStopDate;
    }

    public void setRouteStopDate(Date routeStopDate) {
        this.routeStopDate = routeStopDate;
    }

    public Date getRouteSuspendDate() {
        return this.routeSuspendDate;
    }

    public void setRouteSuspendDate(Date routeSuspendDate) {
        this.routeSuspendDate = routeSuspendDate;
    }

    public int getRouteStartRepeatCount() {
        return this.routeStartRepeatCount;
    }

    public void setRouteStartRepeatCount(int routeStartRepeatCount) {
        this.routeStartRepeatCount = routeStartRepeatCount;
    }

    public long getRouteStartRepeatInterval() {
        return this.routeStartRepeatInterval;
    }

    public void setRouteStartRepeatInterval(long routeStartRepeatInterval) {
        this.routeStartRepeatInterval = routeStartRepeatInterval;
    }

    public int getRouteStopRepeatCount() {
        return this.routeStopRepeatCount;
    }

    public void setRouteStopRepeatCount(int routeStopRepeatCount) {
        this.routeStopRepeatCount = routeStopRepeatCount;
    }

    public long getRouteStopRepeatInterval() {
        return this.routeStopRepeatInterval;
    }

    public void setRouteStopRepeatInterval(long routeStopRepeatInterval) {
        this.routeStopRepeatInterval = routeStopRepeatInterval;
    }

    public int getRouteSuspendRepeatCount() {
        return this.routeSuspendRepeatCount;
    }

    public void setRouteSuspendRepeatCount(int routeSuspendRepeatCount) {
        this.routeSuspendRepeatCount = routeSuspendRepeatCount;
    }

    public long getRouteSuspendRepeatInterval() {
        return this.routeSuspendRepeatInterval;
    }

    public void setRouteSuspendRepeatInterval(long routeSuspendRepeatInterval) {
        this.routeSuspendRepeatInterval = routeSuspendRepeatInterval;
    }

    public void setRouteResumeDate(Date routeResumeDate) {
        this.routeResumeDate = routeResumeDate;
    }

    public Date getRouteResumeDate() {
        return this.routeResumeDate;
    }

    public void setRouteResumeRepeatCount(int routeResumeRepeatCount) {
        this.routeResumeRepeatCount = routeResumeRepeatCount;
    }

    public int getRouteResumeRepeatCount() {
        return this.routeResumeRepeatCount;
    }

    public void setRouteResumeRepeatInterval(long routeResumeRepeatInterval) {
        this.routeResumeRepeatInterval = routeResumeRepeatInterval;
    }

    public long getRouteResumeRepeatInterval() {
        return this.routeResumeRepeatInterval;
    }
}

