/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import org.apache.camel.CamelContext;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;

public class StatefulCamelJob
implements StatefulJob {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext;
        try {
            schedulerContext = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + context.getJobDetail().getName());
        }
        CamelContext camelContext = (CamelContext)schedulerContext.get((Object)"CamelQuartzCamelContext");
        String endpointUri = (String)context.getJobDetail().getJobDataMap().get((Object)"CamelQuartzEndpoint");
        QuartzEndpoint quartzEndpoint = (QuartzEndpoint)camelContext.getEndpoint(endpointUri);
        quartzEndpoint.onJobExecute(context);
    }
}

