/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.component.quartz.QuartzExchange;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzComponent
extends DefaultComponent<QuartzExchange> {
    private static final transient Log log = LogFactory.getLog(QuartzComponent.class);
    private SchedulerFactory factory;
    private Scheduler scheduler;
    private Map<Trigger, JobDetail> triggers;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext context) {
        super(context);
    }

    protected QuartzEndpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String name;
        QuartzEndpoint answer = new QuartzEndpoint(uri, this, this.getScheduler());
        URI u = new URI(uri);
        String group = "Camel";
        String path = u.getPath();
        Trigger cronTrigger = null;
        if (path != null && path.length() > 1) {
            int idx;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((idx = path.indexOf(47)) > 0) {
                cronTrigger = new CronTrigger();
                name = path.substring(0, idx);
                String cronExpression = path.substring(idx + 1);
                cronExpression = cronExpression.replace('/', ' ');
                cronExpression = cronExpression.replace('$', '?');
                log.debug((Object)("Creating cron trigger: " + cronExpression));
                cronTrigger.setCronExpression(cronExpression);
                answer.setTrigger(cronTrigger);
            } else {
                name = path;
            }
            group = u.getHost();
        } else {
            name = u.getHost();
        }
        Trigger trigger = cronTrigger;
        if (trigger == null) {
            trigger = answer.getTrigger();
        }
        trigger.setName(name);
        trigger.setGroup(group);
        Map triggerParameters = IntrospectionSupport.extractProperties((Map)parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties((Map)parameters, (String)"job.");
        IntrospectionSupport.setProperties((Object)trigger, (Map)triggerParameters);
        IntrospectionSupport.setProperties((Object)answer.getJobDetail(), (Map)jobParameters);
        return answer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getScheduler().start();
    }

    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        super.doStop();
    }

    public SchedulerFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.createSchedulerFactory();
        }
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Map triggers) {
        this.triggers = triggers;
    }

    protected SchedulerFactory createSchedulerFactory() {
        return new StdSchedulerFactory();
    }

    protected Scheduler createScheduler() throws SchedulerException {
        return this.getFactory().getScheduler();
    }
}

