/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant;

import io.qdrant.client.grpc.Points;
import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.qdrant.QdrantComponent;
import org.apache.camel.component.qdrant.QdrantConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class QdrantComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private QdrantConfiguration getOrCreateConfiguration(QdrantComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new QdrantConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QdrantComponent target = (QdrantComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apikey": 
            case "apiKey": {
                this.getOrCreateConfiguration(target).setApiKey((String)QdrantComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)QdrantComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((QdrantConfiguration)QdrantComponentConfigurer.property((CamelContext)camelContext, QdrantConfiguration.class, (Object)value));
                return true;
            }
            case "filter": {
                this.getOrCreateConfiguration(target).setFilter((Points.Filter)QdrantComponentConfigurer.property((CamelContext)camelContext, Points.Filter.class, (Object)value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost((String)QdrantComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)QdrantComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults((Integer)QdrantComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "port": {
                this.getOrCreateConfiguration(target).setPort((Integer)QdrantComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout((Duration)QdrantComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "tls": {
                this.getOrCreateConfiguration(target).setTls((Boolean)QdrantComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"filter"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apikey": 
            case "apiKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return QdrantConfiguration.class;
            }
            case "filter": {
                return Points.Filter.class;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresults": 
            case "maxResults": {
                return Integer.TYPE;
            }
            case "port": {
                return Integer.TYPE;
            }
            case "timeout": {
                return Duration.class;
            }
            case "tls": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QdrantComponent target = (QdrantComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "apikey": 
            case "apiKey": {
                return this.getOrCreateConfiguration(target).getApiKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "filter": {
                return this.getOrCreateConfiguration(target).getFilter();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "port": {
                return this.getOrCreateConfiguration(target).getPort();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
            case "tls": {
                return this.getOrCreateConfiguration(target).isTls();
            }
        }
        return null;
    }
}

