/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.component.pulsar.PulsarMessageReceipt;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;

public class DefaultPulsarMessageReceipt
implements PulsarMessageReceipt {
    private final Consumer consumer;
    private final MessageId messageId;

    public DefaultPulsarMessageReceipt(Consumer consumer, MessageId messageId) {
        this.consumer = consumer;
        this.messageId = messageId;
    }

    @Override
    public void acknowledge() throws PulsarClientException {
        this.consumer.acknowledge(this.messageId);
    }

    @Override
    public void acknowledgeCumulative() throws PulsarClientException {
        this.consumer.acknowledgeCumulative(this.messageId);
    }

    @Override
    public CompletableFuture<Void> acknowledgeAsync() {
        return this.consumer.acknowledgeAsync(this.messageId);
    }

    @Override
    public CompletableFuture<Void> acknowledgeCumulativeAsync() {
        return this.consumer.acknowledgeCumulativeAsync(this.messageId);
    }

    @Override
    public void negativeAcknowledge() {
        this.consumer.negativeAcknowledge(this.messageId);
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }
}

