/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.UserId;
import com.pubnub.api.java.PubNub;
import com.pubnub.api.java.v2.PNConfiguration;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pubnub.PubNubComponent;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubConstants;
import org.apache.camel.component.pubnub.PubNubConsumer;
import org.apache.camel.component.pubnub.PubNubProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="pubnub", title="PubNub", syntax="pubnub:channel", category={Category.CLOUD, Category.IOT, Category.MESSAGING}, headersClass=PubNubConstants.class)
public class PubNubEndpoint
extends DefaultEndpoint {
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private PubNub pubnub;
    @UriParam
    private PubNubConfiguration configuration;

    public PubNubEndpoint(String uri, PubNubComponent component, PubNubConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new PubNubProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new PubNubConsumer(this, processor, this.configuration);
    }

    public PubNubConfiguration getConfiguration() {
        return this.configuration;
    }

    public PubNub getPubnub() {
        return this.pubnub;
    }

    public void setPubnub(PubNub pubnub) {
        this.pubnub = pubnub;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.pubnub != null) {
            this.pubnub.destroy();
            this.pubnub = null;
        }
    }

    protected void doStart() throws Exception {
        this.pubnub = this.getPubnub() != null ? this.getPubnub() : this.getInstance();
        super.doStart();
    }

    private PubNub getInstance() throws PubNubException {
        PNConfiguration config = PNConfiguration.builder((UserId)new UserId(this.configuration.getUuid()), (String)this.configuration.getSubscribeKey()).publishKey(this.configuration.getPublishKey()).secretKey(this.configuration.getSecretKey()).authKey(this.configuration.getAuthKey()).secure(this.configuration.isSecure()).build();
        return PubNub.create((PNConfiguration)config);
    }
}

