/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc.lifecycle;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;

public class KeyMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String algorithm;
    private final Instant createdAt;
    private Instant lastUsedAt;
    private Instant expiresAt;
    private Instant nextRotationAt;
    private long usageCount;
    private KeyStatus status;
    private String description;

    public KeyMetadata(String keyId, String algorithm) {
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.lastUsedAt = this.createdAt = Instant.now();
        this.usageCount = 0L;
        this.status = KeyStatus.ACTIVE;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public void updateLastUsed() {
        this.lastUsedAt = Instant.now();
        ++this.usageCount;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Instant getNextRotationAt() {
        return this.nextRotationAt;
    }

    public void setNextRotationAt(Instant nextRotationAt) {
        this.nextRotationAt = nextRotationAt;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public KeyStatus getStatus() {
        return this.status;
    }

    public void setStatus(KeyStatus status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isExpired() {
        return this.status == KeyStatus.EXPIRED || this.expiresAt != null && Instant.now().isAfter(this.expiresAt);
    }

    public boolean needsRotation() {
        return this.status == KeyStatus.PENDING_ROTATION || this.nextRotationAt != null && Instant.now().isAfter(this.nextRotationAt);
    }

    public long getAgeInDays() {
        return Duration.between(this.createdAt, Instant.now()).toDays();
    }

    public String toString() {
        return String.format("KeyMetadata[keyId=%s, algorithm=%s, status=%s, created=%s, age=%d days, usage=%d]", new Object[]{this.keyId, this.algorithm, this.status, this.createdAt, this.getAgeInDays(), this.usageCount});
    }

    public static enum KeyStatus {
        ACTIVE,
        EXPIRED,
        REVOKED,
        PENDING_ROTATION,
        DEPRECATED;

    }
}

